/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.documentation.builder;

import com.mulesoft.documentation.builder.DocBuildException;
import com.mulesoft.documentation.builder.TemplateType;
import com.mulesoft.documentation.builder.util.Utilities;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class Template {
    private String contents;
    private TemplateType type;

    public Template(String contents, TemplateType type2) {
        this.contents = contents;
        this.type = type2;
    }

    public static List<Template> fromDirectory(File directory) {
        ArrayList<Template> templates = new ArrayList<Template>();
        Utilities.validateIsDirectory(directory);
        for (File templateFile : directory.listFiles()) {
            if (!FilenameUtils.getExtension(templateFile.getName()).equals("template")) continue;
            templates.add(Template.fromFile(templateFile));
        }
        return templates;
    }

    public static Template fromString(TemplateType type2, String contents) {
        return new Template(contents, type2);
    }

    public static Template fromFile(File file2) {
        Utilities.validateTemplateFile(file2);
        String contents = Template.getTemplateContents(file2);
        TemplateType type2 = Template.getTemplateType(file2);
        return new Template(contents, type2);
    }

    private static String getTemplateContents(File file2) {
        return Utilities.getFileContentsFromFile(file2);
    }

    private static TemplateType getTemplateType(File file2) {
        String baseName = FilenameUtils.getBaseName(file2.getName());
        if (baseName.equalsIgnoreCase("default")) {
            return TemplateType.DEFAULT;
        }
        if (baseName.equals("landing_page")) {
            return TemplateType.LANDING_PAGE;
        }
        if (baseName.equals("preview")) {
            return TemplateType.PREVIEW;
        }
        String error2 = "Template file's type is not valid: \"" + file2.getName() + "\".";
        throw new DocBuildException(error2);
    }

    private static void validateInputParams(Object[] params2) {
        Utilities.validateCtorObjectsAreNotNull(params2, Template.class.getSimpleName());
    }

    public String getContents() {
        return this.contents;
    }

    public TemplateType getType() {
        return this.type;
    }
}

