/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HelpFormatter {
    public static final int DEFAULT_WIDTH = 74;
    public static final int DEFAULT_LEFT_PAD = 1;
    public static final int DEFAULT_DESC_PAD = 3;
    public static final String DEFAULT_SYNTAX_PREFIX = "usage: ";
    public static final String DEFAULT_OPT_PREFIX = "-";
    public static final String DEFAULT_LONG_OPT_PREFIX = "--";
    public static final String DEFAULT_LONG_OPT_SEPARATOR = " ";
    public static final String DEFAULT_ARG_NAME = "arg";
    @Deprecated
    public int defaultWidth = 74;
    @Deprecated
    public int defaultLeftPad = 1;
    @Deprecated
    public int defaultDescPad = 3;
    @Deprecated
    public String defaultSyntaxPrefix = "usage: ";
    @Deprecated
    public String defaultNewLine = System.getProperty("line.separator");
    @Deprecated
    public String defaultOptPrefix = "-";
    @Deprecated
    public String defaultLongOptPrefix = "--";
    @Deprecated
    public String defaultArgName = "arg";
    protected Comparator<Option> optionComparator = new OptionComparator();
    private String longOptSeparator = " ";

    public void setWidth(int width) {
        this.defaultWidth = width;
    }

    public int getWidth() {
        return this.defaultWidth;
    }

    public void setLeftPadding(int padding) {
        this.defaultLeftPad = padding;
    }

    public int getLeftPadding() {
        return this.defaultLeftPad;
    }

    public void setDescPadding(int padding) {
        this.defaultDescPad = padding;
    }

    public int getDescPadding() {
        return this.defaultDescPad;
    }

    public void setSyntaxPrefix(String prefix) {
        this.defaultSyntaxPrefix = prefix;
    }

    public String getSyntaxPrefix() {
        return this.defaultSyntaxPrefix;
    }

    public void setNewLine(String newline) {
        this.defaultNewLine = newline;
    }

    public String getNewLine() {
        return this.defaultNewLine;
    }

    public void setOptPrefix(String prefix) {
        this.defaultOptPrefix = prefix;
    }

    public String getOptPrefix() {
        return this.defaultOptPrefix;
    }

    public void setLongOptPrefix(String prefix) {
        this.defaultLongOptPrefix = prefix;
    }

    public String getLongOptPrefix() {
        return this.defaultLongOptPrefix;
    }

    public void setLongOptSeparator(String longOptSeparator) {
        this.longOptSeparator = longOptSeparator;
    }

    public String getLongOptSeparator() {
        return this.longOptSeparator;
    }

    public void setArgName(String name2) {
        this.defaultArgName = name2;
    }

    public String getArgName() {
        return this.defaultArgName;
    }

    public Comparator<Option> getOptionComparator() {
        return this.optionComparator;
    }

    public void setOptionComparator(Comparator<Option> comparator) {
        this.optionComparator = comparator;
    }

    public void printHelp(String cmdLineSyntax, Options options2) {
        this.printHelp(this.getWidth(), cmdLineSyntax, null, options2, null, false);
    }

    public void printHelp(String cmdLineSyntax, Options options2, boolean autoUsage) {
        this.printHelp(this.getWidth(), cmdLineSyntax, null, options2, null, autoUsage);
    }

    public void printHelp(String cmdLineSyntax, String header, Options options2, String footer) {
        this.printHelp(cmdLineSyntax, header, options2, footer, false);
    }

    public void printHelp(String cmdLineSyntax, String header, Options options2, String footer, boolean autoUsage) {
        this.printHelp(this.getWidth(), cmdLineSyntax, header, options2, footer, autoUsage);
    }

    public void printHelp(int width, String cmdLineSyntax, String header, Options options2, String footer) {
        this.printHelp(width, cmdLineSyntax, header, options2, footer, false);
    }

    public void printHelp(int width, String cmdLineSyntax, String header, Options options2, String footer, boolean autoUsage) {
        PrintWriter pw = new PrintWriter(System.out);
        this.printHelp(pw, width, cmdLineSyntax, header, options2, this.getLeftPadding(), this.getDescPadding(), footer, autoUsage);
        pw.flush();
    }

    public void printHelp(PrintWriter pw, int width, String cmdLineSyntax, String header, Options options2, int leftPad, int descPad, String footer) {
        this.printHelp(pw, width, cmdLineSyntax, header, options2, leftPad, descPad, footer, false);
    }

    public void printHelp(PrintWriter pw, int width, String cmdLineSyntax, String header, Options options2, int leftPad, int descPad, String footer, boolean autoUsage) {
        if (cmdLineSyntax == null || cmdLineSyntax.length() == 0) {
            throw new IllegalArgumentException("cmdLineSyntax not provided");
        }
        if (autoUsage) {
            this.printUsage(pw, width, cmdLineSyntax, options2);
        } else {
            this.printUsage(pw, width, cmdLineSyntax);
        }
        if (header != null && header.trim().length() > 0) {
            this.printWrapped(pw, width, header);
        }
        this.printOptions(pw, width, options2, leftPad, descPad);
        if (footer != null && footer.trim().length() > 0) {
            this.printWrapped(pw, width, footer);
        }
    }

    public void printUsage(PrintWriter pw, int width, String app, Options options2) {
        StringBuffer buff = new StringBuffer(this.getSyntaxPrefix()).append(app).append(DEFAULT_LONG_OPT_SEPARATOR);
        ArrayList<OptionGroup> processedGroups = new ArrayList<OptionGroup>();
        ArrayList<Option> optList = new ArrayList<Option>(options2.getOptions());
        if (this.getOptionComparator() != null) {
            Collections.sort(optList, this.getOptionComparator());
        }
        Iterator it = optList.iterator();
        while (it.hasNext()) {
            Option option = (Option)it.next();
            OptionGroup group2 = options2.getOptionGroup(option);
            if (group2 != null) {
                if (!processedGroups.contains(group2)) {
                    processedGroups.add(group2);
                    this.appendOptionGroup(buff, group2);
                }
            } else {
                this.appendOption(buff, option, option.isRequired());
            }
            if (!it.hasNext()) continue;
            buff.append(DEFAULT_LONG_OPT_SEPARATOR);
        }
        this.printWrapped(pw, width, buff.toString().indexOf(32) + 1, buff.toString());
    }

    private void appendOptionGroup(StringBuffer buff, OptionGroup group2) {
        if (!group2.isRequired()) {
            buff.append("[");
        }
        ArrayList<Option> optList = new ArrayList<Option>(group2.getOptions());
        if (this.getOptionComparator() != null) {
            Collections.sort(optList, this.getOptionComparator());
        }
        Iterator it = optList.iterator();
        while (it.hasNext()) {
            this.appendOption(buff, (Option)it.next(), true);
            if (!it.hasNext()) continue;
            buff.append(" | ");
        }
        if (!group2.isRequired()) {
            buff.append("]");
        }
    }

    private void appendOption(StringBuffer buff, Option option, boolean required) {
        if (!required) {
            buff.append("[");
        }
        if (option.getOpt() != null) {
            buff.append(DEFAULT_OPT_PREFIX).append(option.getOpt());
        } else {
            buff.append(DEFAULT_LONG_OPT_PREFIX).append(option.getLongOpt());
        }
        if (option.hasArg() && (option.getArgName() == null || option.getArgName().length() != 0)) {
            buff.append(option.getOpt() == null ? this.longOptSeparator : DEFAULT_LONG_OPT_SEPARATOR);
            buff.append("<").append(option.getArgName() != null ? option.getArgName() : this.getArgName()).append(">");
        }
        if (!required) {
            buff.append("]");
        }
    }

    public void printUsage(PrintWriter pw, int width, String cmdLineSyntax) {
        int argPos = cmdLineSyntax.indexOf(32) + 1;
        this.printWrapped(pw, width, this.getSyntaxPrefix().length() + argPos, this.getSyntaxPrefix() + cmdLineSyntax);
    }

    public void printOptions(PrintWriter pw, int width, Options options2, int leftPad, int descPad) {
        StringBuffer sb = new StringBuffer();
        this.renderOptions(sb, width, options2, leftPad, descPad);
        pw.println(sb.toString());
    }

    public void printWrapped(PrintWriter pw, int width, String text) {
        this.printWrapped(pw, width, 0, text);
    }

    public void printWrapped(PrintWriter pw, int width, int nextLineTabStop, String text) {
        StringBuffer sb = new StringBuffer(text.length());
        this.renderWrappedTextBlock(sb, width, nextLineTabStop, text);
        pw.println(sb.toString());
    }

    protected StringBuffer renderOptions(StringBuffer sb, int width, Options options2, int leftPad, int descPad) {
        String lpad = this.createPadding(leftPad);
        String dpad = this.createPadding(descPad);
        int max2 = 0;
        ArrayList<StringBuffer> prefixList = new ArrayList<StringBuffer>();
        List<Option> optList = options2.helpOptions();
        if (this.getOptionComparator() != null) {
            Collections.sort(optList, this.getOptionComparator());
        }
        for (Option option : optList) {
            StringBuffer optBuf = new StringBuffer();
            if (option.getOpt() == null) {
                optBuf.append(lpad).append("   ").append(this.getLongOptPrefix()).append(option.getLongOpt());
            } else {
                optBuf.append(lpad).append(this.getOptPrefix()).append(option.getOpt());
                if (option.hasLongOpt()) {
                    optBuf.append(',').append(this.getLongOptPrefix()).append(option.getLongOpt());
                }
            }
            if (option.hasArg()) {
                String argName = option.getArgName();
                if (argName != null && argName.length() == 0) {
                    optBuf.append(' ');
                } else {
                    optBuf.append(option.hasLongOpt() ? this.longOptSeparator : DEFAULT_LONG_OPT_SEPARATOR);
                    optBuf.append("<").append(argName != null ? option.getArgName() : this.getArgName()).append(">");
                }
            }
            prefixList.add(optBuf);
            max2 = optBuf.length() > max2 ? optBuf.length() : max2;
        }
        int x = 0;
        Iterator<Option> it = optList.iterator();
        while (it.hasNext()) {
            StringBuilder optBuf;
            Option option = it.next();
            if ((optBuf = new StringBuilder(((StringBuffer)prefixList.get(x++)).toString())).length() < max2) {
                optBuf.append(this.createPadding(max2 - optBuf.length()));
            }
            optBuf.append(dpad);
            int nextLineTabStop = max2 + descPad;
            if (option.getDescription() != null) {
                optBuf.append(option.getDescription());
            }
            this.renderWrappedText(sb, width, nextLineTabStop, optBuf.toString());
            if (!it.hasNext()) continue;
            sb.append(this.getNewLine());
        }
        return sb;
    }

    protected StringBuffer renderWrappedText(StringBuffer sb, int width, int nextLineTabStop, String text) {
        int pos2 = this.findWrapPos(text, width, 0);
        if (pos2 == -1) {
            sb.append(this.rtrim(text));
            return sb;
        }
        sb.append(this.rtrim(text.substring(0, pos2))).append(this.getNewLine());
        if (nextLineTabStop >= width) {
            nextLineTabStop = 1;
        }
        String padding = this.createPadding(nextLineTabStop);
        while (true) {
            if ((pos2 = this.findWrapPos(text = padding + text.substring(pos2).trim(), width, 0)) == -1) {
                sb.append(text);
                return sb;
            }
            if (text.length() > width && pos2 == nextLineTabStop - 1) {
                pos2 = width;
            }
            sb.append(this.rtrim(text.substring(0, pos2))).append(this.getNewLine());
        }
    }

    private Appendable renderWrappedTextBlock(StringBuffer sb, int width, int nextLineTabStop, String text) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new StringReader(text));
            boolean firstLine = true;
            while ((line = in.readLine()) != null) {
                if (!firstLine) {
                    sb.append(this.getNewLine());
                } else {
                    firstLine = false;
                }
                this.renderWrappedText(sb, width, nextLineTabStop, line);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return sb;
    }

    protected int findWrapPos(String text, int width, int startPos) {
        char c;
        int pos2 = text.indexOf(10, startPos);
        if (pos2 != -1 && pos2 <= width) {
            return pos2 + 1;
        }
        pos2 = text.indexOf(9, startPos);
        if (pos2 != -1 && pos2 <= width) {
            return pos2 + 1;
        }
        if (startPos + width >= text.length()) {
            return -1;
        }
        for (pos2 = startPos + width; pos2 >= startPos && (c = text.charAt(pos2)) != ' ' && c != '\n' && c != '\r'; --pos2) {
        }
        if (pos2 > startPos) {
            return pos2;
        }
        pos2 = startPos + width;
        return pos2 == text.length() ? -1 : pos2;
    }

    protected String createPadding(int len) {
        char[] padding = new char[len];
        Arrays.fill(padding, ' ');
        return new String(padding);
    }

    protected String rtrim(String s2) {
        int pos2;
        if (s2 == null || s2.length() == 0) {
            return s2;
        }
        for (pos2 = s2.length(); pos2 > 0 && Character.isWhitespace(s2.charAt(pos2 - 1)); --pos2) {
        }
        return s2.substring(0, pos2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OptionComparator
    implements Comparator<Option>,
    Serializable {
        private static final long serialVersionUID = 5305467873966684014L;

        private OptionComparator() {
        }

        @Override
        public int compare(Option opt1, Option opt2) {
            return opt1.getKey().compareToIgnoreCase(opt2.getKey());
        }
    }
}

