/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.exception;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DefaultExceptionContext
implements ExceptionContext,
Serializable {
    private static final long serialVersionUID = 20110706L;
    private final List<Pair<String, Object>> contextValues = new ArrayList<Pair<String, Object>>();

    @Override
    public DefaultExceptionContext addContextValue(String label2, Object value2) {
        this.contextValues.add(new ImmutablePair<String, Object>(label2, value2));
        return this;
    }

    @Override
    public DefaultExceptionContext setContextValue(String label2, Object value2) {
        Iterator<Pair<String, Object>> iter = this.contextValues.iterator();
        while (iter.hasNext()) {
            Pair<String, Object> p2 = iter.next();
            if (!StringUtils.equals(label2, p2.getKey())) continue;
            iter.remove();
        }
        this.addContextValue(label2, value2);
        return this;
    }

    @Override
    public List<Object> getContextValues(String label2) {
        ArrayList<Object> values2 = new ArrayList<Object>();
        for (Pair<String, Object> pair : this.contextValues) {
            if (!StringUtils.equals(label2, pair.getKey())) continue;
            values2.add(pair.getValue());
        }
        return values2;
    }

    @Override
    public Object getFirstContextValue(String label2) {
        for (Pair<String, Object> pair : this.contextValues) {
            if (!StringUtils.equals(label2, pair.getKey())) continue;
            return pair.getValue();
        }
        return null;
    }

    @Override
    public Set<String> getContextLabels() {
        HashSet<String> labels = new HashSet<String>();
        for (Pair<String, Object> pair : this.contextValues) {
            labels.add(pair.getKey());
        }
        return labels;
    }

    @Override
    public List<Pair<String, Object>> getContextEntries() {
        return this.contextValues;
    }

    @Override
    public String getFormattedExceptionMessage(String baseMessage) {
        StringBuilder buffer = new StringBuilder(256);
        if (baseMessage != null) {
            buffer.append(baseMessage);
        }
        if (this.contextValues.size() > 0) {
            if (buffer.length() > 0) {
                buffer.append('\n');
            }
            buffer.append("Exception Context:\n");
            int i2 = 0;
            for (Pair<String, Object> pair : this.contextValues) {
                buffer.append("\t[");
                buffer.append(++i2);
                buffer.append(':');
                buffer.append(pair.getKey());
                buffer.append("=");
                Object value2 = pair.getValue();
                if (value2 == null) {
                    buffer.append("null");
                } else {
                    String valueStr;
                    try {
                        valueStr = value2.toString();
                    }
                    catch (Exception e) {
                        valueStr = "Exception thrown on toString(): " + ExceptionUtils.getStackTrace(e);
                    }
                    buffer.append(valueStr);
                }
                buffer.append("]\n");
            }
            buffer.append("---------------------------------");
        }
        return buffer.toString();
    }
}

