/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.math;

public class IEEE754rUtils {
    public static double min(double[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        double min2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            min2 = IEEE754rUtils.min(array[i2], min2);
        }
        return min2;
    }

    public static float min(float[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        float min2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            min2 = IEEE754rUtils.min(array[i2], min2);
        }
        return min2;
    }

    public static double min(double a, double b2, double c) {
        return IEEE754rUtils.min(IEEE754rUtils.min(a, b2), c);
    }

    public static double min(double a, double b2) {
        if (Double.isNaN(a)) {
            return b2;
        }
        if (Double.isNaN(b2)) {
            return a;
        }
        return Math.min(a, b2);
    }

    public static float min(float a, float b2, float c) {
        return IEEE754rUtils.min(IEEE754rUtils.min(a, b2), c);
    }

    public static float min(float a, float b2) {
        if (Float.isNaN(a)) {
            return b2;
        }
        if (Float.isNaN(b2)) {
            return a;
        }
        return Math.min(a, b2);
    }

    public static double max(double[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        double max2 = array[0];
        for (int j = 1; j < array.length; ++j) {
            max2 = IEEE754rUtils.max(array[j], max2);
        }
        return max2;
    }

    public static float max(float[] array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
        float max2 = array[0];
        for (int j = 1; j < array.length; ++j) {
            max2 = IEEE754rUtils.max(array[j], max2);
        }
        return max2;
    }

    public static double max(double a, double b2, double c) {
        return IEEE754rUtils.max(IEEE754rUtils.max(a, b2), c);
    }

    public static double max(double a, double b2) {
        if (Double.isNaN(a)) {
            return b2;
        }
        if (Double.isNaN(b2)) {
            return a;
        }
        return Math.max(a, b2);
    }

    public static float max(float a, float b2, float c) {
        return IEEE754rUtils.max(IEEE754rUtils.max(a, b2), c);
    }

    public static float max(float a, float b2) {
        if (Float.isNaN(a)) {
            return b2;
        }
        if (Float.isNaN(b2)) {
            return a;
        }
        return Math.max(a, b2);
    }
}

