/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.math;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.lang3.StringUtils;

public class NumberUtils {
    public static final Long LONG_ZERO = 0L;
    public static final Long LONG_ONE = 1L;
    public static final Long LONG_MINUS_ONE = -1L;
    public static final Integer INTEGER_ZERO = 0;
    public static final Integer INTEGER_ONE = 1;
    public static final Integer INTEGER_MINUS_ONE = -1;
    public static final Short SHORT_ZERO = 0;
    public static final Short SHORT_ONE = 1;
    public static final Short SHORT_MINUS_ONE = -1;
    public static final Byte BYTE_ZERO = 0;
    public static final Byte BYTE_ONE = 1;
    public static final Byte BYTE_MINUS_ONE = -1;
    public static final Double DOUBLE_ZERO = 0.0;
    public static final Double DOUBLE_ONE = 1.0;
    public static final Double DOUBLE_MINUS_ONE = -1.0;
    public static final Float FLOAT_ZERO = Float.valueOf(0.0f);
    public static final Float FLOAT_ONE = Float.valueOf(1.0f);
    public static final Float FLOAT_MINUS_ONE = Float.valueOf(-1.0f);

    public static int toInt(String str) {
        return NumberUtils.toInt(str, 0);
    }

    public static int toInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static long toLong(String str) {
        return NumberUtils.toLong(str, 0L);
    }

    public static long toLong(String str, long defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static float toFloat(String str) {
        return NumberUtils.toFloat(str, 0.0f);
    }

    public static float toFloat(String str, float defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Float.parseFloat(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static double toDouble(String str) {
        return NumberUtils.toDouble(str, 0.0);
    }

    public static double toDouble(String str, double defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static byte toByte(String str) {
        return NumberUtils.toByte(str, (byte)0);
    }

    public static byte toByte(String str, byte defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Byte.parseByte(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static short toShort(String str) {
        return NumberUtils.toShort(str, (short)0);
    }

    public static short toShort(String str, short defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Short.parseShort(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static Number createNumber(String str) throws NumberFormatException {
        String exp2;
        String mant;
        String dec;
        if (str == null) {
            return null;
        }
        if (StringUtils.isBlank(str)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        String[] hex_prefixes = new String[]{"0x", "0X", "-0x", "-0X", "#", "-#"};
        int pfxLen = 0;
        for (String pfx : hex_prefixes) {
            if (!str.startsWith(pfx)) continue;
            pfxLen += pfx.length();
            break;
        }
        if (pfxLen > 0) {
            char firstSigDigit = '\u0000';
            for (int i2 = pfxLen; i2 < str.length() && (firstSigDigit = str.charAt(i2)) == '0'; ++i2) {
                ++pfxLen;
            }
            int hexDigits = str.length() - pfxLen;
            if (hexDigits > 16 || hexDigits == 16 && firstSigDigit > '7') {
                return NumberUtils.createBigInteger(str);
            }
            if (hexDigits > 8 || hexDigits == 8 && firstSigDigit > '7') {
                return NumberUtils.createLong(str);
            }
            return NumberUtils.createInteger(str);
        }
        char lastChar = str.charAt(str.length() - 1);
        int decPos = str.indexOf(46);
        int expPos = str.indexOf(101) + str.indexOf(69) + 1;
        int numDecimals = 0;
        if (decPos > -1) {
            if (expPos > -1) {
                if (expPos < decPos || expPos > str.length()) {
                    throw new NumberFormatException(str + " is not a valid number.");
                }
                dec = str.substring(decPos + 1, expPos);
            } else {
                dec = str.substring(decPos + 1);
            }
            mant = str.substring(0, decPos);
            numDecimals = dec.length();
        } else {
            if (expPos > -1) {
                if (expPos > str.length()) {
                    throw new NumberFormatException(str + " is not a valid number.");
                }
                mant = str.substring(0, expPos);
            } else {
                mant = str;
            }
            dec = null;
        }
        if (!Character.isDigit(lastChar) && lastChar != '.') {
            exp2 = expPos > -1 && expPos < str.length() - 1 ? str.substring(expPos + 1, str.length() - 1) : null;
            String numeric = str.substring(0, str.length() - 1);
            boolean allZeros = NumberUtils.isAllZeros(mant) && NumberUtils.isAllZeros(exp2);
            switch (lastChar) {
                case 'L': 
                case 'l': {
                    if (dec == null && exp2 == null && (numeric.charAt(0) == '-' && NumberUtils.isDigits(numeric.substring(1)) || NumberUtils.isDigits(numeric))) {
                        try {
                            return NumberUtils.createLong(numeric);
                        }
                        catch (NumberFormatException nfe) {
                            return NumberUtils.createBigInteger(numeric);
                        }
                    }
                    throw new NumberFormatException(str + " is not a valid number.");
                }
                case 'F': 
                case 'f': {
                    try {
                        Float f = NumberUtils.createFloat(numeric);
                        if (!f.isInfinite() && (f.floatValue() != 0.0f || allZeros)) {
                            return f;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
                case 'D': 
                case 'd': {
                    try {
                        Double d = NumberUtils.createDouble(numeric);
                        if (!d.isInfinite() && ((double)d.floatValue() != 0.0 || allZeros)) {
                            return d;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                    try {
                        return NumberUtils.createBigDecimal(numeric);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
            }
            throw new NumberFormatException(str + " is not a valid number.");
        }
        exp2 = expPos > -1 && expPos < str.length() - 1 ? str.substring(expPos + 1, str.length()) : null;
        if (dec == null && exp2 == null) {
            try {
                return NumberUtils.createInteger(str);
            }
            catch (NumberFormatException nfe) {
                try {
                    return NumberUtils.createLong(str);
                }
                catch (NumberFormatException nfe2) {
                    return NumberUtils.createBigInteger(str);
                }
            }
        }
        boolean allZeros = NumberUtils.isAllZeros(mant) && NumberUtils.isAllZeros(exp2);
        try {
            Float f;
            if (numDecimals <= 7 && !(f = NumberUtils.createFloat(str)).isInfinite() && (f.floatValue() != 0.0f || allZeros)) {
                return f;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        try {
            Double d;
            if (numDecimals <= 16 && !(d = NumberUtils.createDouble(str)).isInfinite() && (d != 0.0 || allZeros)) {
                return d;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return NumberUtils.createBigDecimal(str);
    }

    private static boolean isAllZeros(String str) {
        if (str == null) {
            return true;
        }
        for (int i2 = str.length() - 1; i2 >= 0; --i2) {
            if (str.charAt(i2) == '0') continue;
            return false;
        }
        return str.length() > 0;
    }

    public static Float createFloat(String str) {
        if (str == null) {
            return null;
        }
        return Float.valueOf(str);
    }

    public static Double createDouble(String str) {
        if (str == null) {
            return null;
        }
        return Double.valueOf(str);
    }

    public static Integer createInteger(String str) {
        if (str == null) {
            return null;
        }
        return Integer.decode(str);
    }

    public static Long createLong(String str) {
        if (str == null) {
            return null;
        }
        return Long.decode(str);
    }

    public static BigInteger createBigInteger(String str) {
        if (str == null) {
            return null;
        }
        int pos2 = 0;
        int radix = 10;
        boolean negate2 = false;
        if (str.startsWith("-")) {
            negate2 = true;
            pos2 = 1;
        }
        if (str.startsWith("0x", pos2) || str.startsWith("0x", pos2)) {
            radix = 16;
            pos2 += 2;
        } else if (str.startsWith("#", pos2)) {
            radix = 16;
            ++pos2;
        } else if (str.startsWith("0", pos2) && str.length() > pos2 + 1) {
            radix = 8;
            ++pos2;
        }
        BigInteger value2 = new BigInteger(str.substring(pos2), radix);
        return negate2 ? value2.negate() : value2;
    }

    public static BigDecimal createBigDecimal(String str) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isBlank(str)) {
            throw new NumberFormatException("A blank string is not a valid number");
        }
        if (str.trim().startsWith("--")) {
            throw new NumberFormatException(str + " is not a valid number.");
        }
        return new BigDecimal(str);
    }

    public static long min(long[] array) {
        NumberUtils.validateArray(array);
        long min2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (array[i2] >= min2) continue;
            min2 = array[i2];
        }
        return min2;
    }

    public static int min(int[] array) {
        NumberUtils.validateArray(array);
        int min2 = array[0];
        for (int j = 1; j < array.length; ++j) {
            if (array[j] >= min2) continue;
            min2 = array[j];
        }
        return min2;
    }

    public static short min(short[] array) {
        NumberUtils.validateArray(array);
        short min2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (array[i2] >= min2) continue;
            min2 = array[i2];
        }
        return min2;
    }

    public static byte min(byte[] array) {
        NumberUtils.validateArray(array);
        byte min2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (array[i2] >= min2) continue;
            min2 = array[i2];
        }
        return min2;
    }

    public static double min(double[] array) {
        NumberUtils.validateArray(array);
        double min2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (Double.isNaN(array[i2])) {
                return Double.NaN;
            }
            if (!(array[i2] < min2)) continue;
            min2 = array[i2];
        }
        return min2;
    }

    public static float min(float[] array) {
        NumberUtils.validateArray(array);
        float min2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (Float.isNaN(array[i2])) {
                return Float.NaN;
            }
            if (!(array[i2] < min2)) continue;
            min2 = array[i2];
        }
        return min2;
    }

    public static long max(long[] array) {
        NumberUtils.validateArray(array);
        long max2 = array[0];
        for (int j = 1; j < array.length; ++j) {
            if (array[j] <= max2) continue;
            max2 = array[j];
        }
        return max2;
    }

    public static int max(int[] array) {
        NumberUtils.validateArray(array);
        int max2 = array[0];
        for (int j = 1; j < array.length; ++j) {
            if (array[j] <= max2) continue;
            max2 = array[j];
        }
        return max2;
    }

    public static short max(short[] array) {
        NumberUtils.validateArray(array);
        short max2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (array[i2] <= max2) continue;
            max2 = array[i2];
        }
        return max2;
    }

    public static byte max(byte[] array) {
        NumberUtils.validateArray(array);
        byte max2 = array[0];
        for (int i2 = 1; i2 < array.length; ++i2) {
            if (array[i2] <= max2) continue;
            max2 = array[i2];
        }
        return max2;
    }

    public static double max(double[] array) {
        NumberUtils.validateArray(array);
        double max2 = array[0];
        for (int j = 1; j < array.length; ++j) {
            if (Double.isNaN(array[j])) {
                return Double.NaN;
            }
            if (!(array[j] > max2)) continue;
            max2 = array[j];
        }
        return max2;
    }

    public static float max(float[] array) {
        NumberUtils.validateArray(array);
        float max2 = array[0];
        for (int j = 1; j < array.length; ++j) {
            if (Float.isNaN(array[j])) {
                return Float.NaN;
            }
            if (!(array[j] > max2)) continue;
            max2 = array[j];
        }
        return max2;
    }

    private static void validateArray(Object array) {
        if (array == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        if (Array.getLength(array) == 0) {
            throw new IllegalArgumentException("Array cannot be empty.");
        }
    }

    public static long min(long a, long b2, long c) {
        if (b2 < a) {
            a = b2;
        }
        if (c < a) {
            a = c;
        }
        return a;
    }

    public static int min(int a, int b2, int c) {
        if (b2 < a) {
            a = b2;
        }
        if (c < a) {
            a = c;
        }
        return a;
    }

    public static short min(short a, short b2, short c) {
        if (b2 < a) {
            a = b2;
        }
        if (c < a) {
            a = c;
        }
        return a;
    }

    public static byte min(byte a, byte b2, byte c) {
        if (b2 < a) {
            a = b2;
        }
        if (c < a) {
            a = c;
        }
        return a;
    }

    public static double min(double a, double b2, double c) {
        return Math.min(Math.min(a, b2), c);
    }

    public static float min(float a, float b2, float c) {
        return Math.min(Math.min(a, b2), c);
    }

    public static long max(long a, long b2, long c) {
        if (b2 > a) {
            a = b2;
        }
        if (c > a) {
            a = c;
        }
        return a;
    }

    public static int max(int a, int b2, int c) {
        if (b2 > a) {
            a = b2;
        }
        if (c > a) {
            a = c;
        }
        return a;
    }

    public static short max(short a, short b2, short c) {
        if (b2 > a) {
            a = b2;
        }
        if (c > a) {
            a = c;
        }
        return a;
    }

    public static byte max(byte a, byte b2, byte c) {
        if (b2 > a) {
            a = b2;
        }
        if (c > a) {
            a = c;
        }
        return a;
    }

    public static double max(double a, double b2, double c) {
        return Math.max(Math.max(a, b2), c);
    }

    public static float max(float a, float b2, float c) {
        return Math.max(Math.max(a, b2), c);
    }

    public static boolean isDigits(String str) {
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        for (int i2 = 0; i2 < str.length(); ++i2) {
            if (Character.isDigit(str.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(String str) {
        int i2;
        int start2;
        if (StringUtils.isEmpty(str)) {
            return false;
        }
        char[] chars2 = str.toCharArray();
        int sz = chars2.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start2 = chars2[0] == '-' ? 1 : 0;
        if (sz > start2 + 1 && chars2[start2] == '0') {
            if (chars2[start2 + 1] == 'x' || chars2[start2 + 1] == 'X') {
                int i3 = start2 + 2;
                if (i3 == sz) {
                    return false;
                }
                while (i3 < chars2.length) {
                    if (!(chars2[i3] >= '0' && chars2[i3] <= '9' || chars2[i3] >= 'a' && chars2[i3] <= 'f' || chars2[i3] >= 'A' && chars2[i3] <= 'F')) {
                        return false;
                    }
                    ++i3;
                }
                return true;
            }
            if (Character.isDigit(chars2[start2 + 1])) {
                for (int i4 = start2 + 1; i4 < chars2.length; ++i4) {
                    if (chars2[i4] >= '0' && chars2[i4] <= '7') continue;
                    return false;
                }
                return true;
            }
        }
        --sz;
        for (i2 = start2; i2 < sz || i2 < sz + 1 && allowSigns && !foundDigit; ++i2) {
            if (chars2[i2] >= '0' && chars2[i2] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars2[i2] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars2[i2] == 'e' || chars2[i2] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (chars2[i2] == '+' || chars2[i2] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i2 < chars2.length) {
            if (chars2[i2] >= '0' && chars2[i2] <= '9') {
                return true;
            }
            if (chars2[i2] == 'e' || chars2[i2] == 'E') {
                return false;
            }
            if (chars2[i2] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                return foundDigit;
            }
            if (!(allowSigns || chars2[i2] != 'd' && chars2[i2] != 'D' && chars2[i2] != 'f' && chars2[i2] != 'F')) {
                return foundDigit;
            }
            if (chars2[i2] == 'l' || chars2[i2] == 'L') {
                return foundDigit && !hasExp && !hasDecPoint;
            }
            return false;
        }
        return !allowSigns && foundDigit;
    }
}

