/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text.translate;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;

public class LookupTranslator
extends CharSequenceTranslator {
    private final HashMap<String, CharSequence> lookupMap = new HashMap();
    private final int shortest;
    private final int longest;

    public LookupTranslator(CharSequence[] ... lookup) {
        int _shortest = Integer.MAX_VALUE;
        int _longest = 0;
        if (lookup != null) {
            for (CharSequence[] seq : lookup) {
                this.lookupMap.put(seq[0].toString(), seq[1]);
                int sz = seq[0].length();
                if (sz < _shortest) {
                    _shortest = sz;
                }
                if (sz <= _longest) continue;
                _longest = sz;
            }
        }
        this.shortest = _shortest;
        this.longest = _longest;
    }

    @Override
    public int translate(CharSequence input, int index2, Writer out) throws IOException {
        int max2 = this.longest;
        if (index2 + this.longest > input.length()) {
            max2 = input.length() - index2;
        }
        for (int i2 = max2; i2 >= this.shortest; --i2) {
            CharSequence subSeq = input.subSequence(index2, index2 + i2);
            CharSequence result2 = this.lookupMap.get(subSeq.toString());
            if (result2 == null) continue;
            out.write(result2.toString());
            return i2;
        }
        return 0;
    }
}

