/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class DurationFormatUtils {
    public static final String ISO_EXTENDED_FORMAT_PATTERN = "'P'yyyy'Y'M'M'd'DT'H'H'm'M's.S'S'";
    static final Object y = "y";
    static final Object M = "M";
    static final Object d = "d";
    static final Object H = "H";
    static final Object m = "m";
    static final Object s = "s";
    static final Object S = "S";

    public static String formatDurationHMS(long durationMillis) {
        return DurationFormatUtils.formatDuration(durationMillis, "H:mm:ss.SSS");
    }

    public static String formatDurationISO(long durationMillis) {
        return DurationFormatUtils.formatDuration(durationMillis, ISO_EXTENDED_FORMAT_PATTERN, false);
    }

    public static String formatDuration(long durationMillis, String format) {
        return DurationFormatUtils.formatDuration(durationMillis, format, true);
    }

    public static String formatDuration(long durationMillis, String format, boolean padWithZeros) {
        Token[] tokens = DurationFormatUtils.lexx(format);
        long days = 0L;
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        long milliseconds = durationMillis;
        if (Token.containsTokenWithValue(tokens, d)) {
            days = milliseconds / 86400000L;
            milliseconds -= days * 86400000L;
        }
        if (Token.containsTokenWithValue(tokens, H)) {
            hours = milliseconds / 3600000L;
            milliseconds -= hours * 3600000L;
        }
        if (Token.containsTokenWithValue(tokens, m)) {
            minutes = milliseconds / 60000L;
            milliseconds -= minutes * 60000L;
        }
        if (Token.containsTokenWithValue(tokens, s)) {
            seconds = milliseconds / 1000L;
            milliseconds -= seconds * 1000L;
        }
        return DurationFormatUtils.format(tokens, 0L, 0L, days, hours, minutes, seconds, milliseconds, padWithZeros);
    }

    public static String formatDurationWords(long durationMillis, boolean suppressLeadingZeroElements, boolean suppressTrailingZeroElements) {
        String tmp;
        String duration = DurationFormatUtils.formatDuration(durationMillis, "d' days 'H' hours 'm' minutes 's' seconds'");
        if (suppressLeadingZeroElements) {
            duration = " " + duration;
            tmp = StringUtils.replaceOnce(duration, " 0 days", "");
            if (tmp.length() != duration.length() && (tmp = StringUtils.replaceOnce(duration = tmp, " 0 hours", "")).length() != duration.length()) {
                duration = tmp;
                duration = tmp = StringUtils.replaceOnce(duration, " 0 minutes", "");
                if (tmp.length() != duration.length()) {
                    duration = StringUtils.replaceOnce(tmp, " 0 seconds", "");
                }
            }
            if (duration.length() != 0) {
                duration = duration.substring(1);
            }
        }
        if (suppressTrailingZeroElements && (tmp = StringUtils.replaceOnce(duration, " 0 seconds", "")).length() != duration.length() && (tmp = StringUtils.replaceOnce(duration = tmp, " 0 minutes", "")).length() != duration.length() && (tmp = StringUtils.replaceOnce(duration = tmp, " 0 hours", "")).length() != duration.length()) {
            duration = StringUtils.replaceOnce(tmp, " 0 days", "");
        }
        duration = " " + duration;
        duration = StringUtils.replaceOnce(duration, " 1 seconds", " 1 second");
        duration = StringUtils.replaceOnce(duration, " 1 minutes", " 1 minute");
        duration = StringUtils.replaceOnce(duration, " 1 hours", " 1 hour");
        duration = StringUtils.replaceOnce(duration, " 1 days", " 1 day");
        return duration.trim();
    }

    public static String formatPeriodISO(long startMillis, long endMillis) {
        return DurationFormatUtils.formatPeriod(startMillis, endMillis, ISO_EXTENDED_FORMAT_PATTERN, false, TimeZone.getDefault());
    }

    public static String formatPeriod(long startMillis, long endMillis, String format) {
        return DurationFormatUtils.formatPeriod(startMillis, endMillis, format, true, TimeZone.getDefault());
    }

    public static String formatPeriod(long startMillis, long endMillis, String format, boolean padWithZeros, TimeZone timezone) {
        Token[] tokens = DurationFormatUtils.lexx(format);
        Calendar start2 = Calendar.getInstance(timezone);
        start2.setTime(new Date(startMillis));
        Calendar end2 = Calendar.getInstance(timezone);
        end2.setTime(new Date(endMillis));
        int milliseconds = end2.get(14) - start2.get(14);
        int seconds = end2.get(13) - start2.get(13);
        int minutes = end2.get(12) - start2.get(12);
        int hours = end2.get(11) - start2.get(11);
        int days = end2.get(5) - start2.get(5);
        int months = end2.get(2) - start2.get(2);
        int years = end2.get(1) - start2.get(1);
        while (milliseconds < 0) {
            milliseconds += 1000;
            --seconds;
        }
        while (seconds < 0) {
            seconds += 60;
            --minutes;
        }
        while (minutes < 0) {
            minutes += 60;
            --hours;
        }
        while (hours < 0) {
            hours += 24;
            --days;
        }
        if (Token.containsTokenWithValue(tokens, M)) {
            while (days < 0) {
                days += start2.getActualMaximum(5);
                --months;
                start2.add(2, 1);
            }
            while (months < 0) {
                months += 12;
                --years;
            }
            if (!Token.containsTokenWithValue(tokens, y) && years != 0) {
                while (years != 0) {
                    months += 12 * years;
                    years = 0;
                }
            }
        } else {
            if (!Token.containsTokenWithValue(tokens, y)) {
                int target = end2.get(1);
                if (months < 0) {
                    --target;
                }
                while (start2.get(1) != target) {
                    days += start2.getActualMaximum(6) - start2.get(6);
                    if (start2 instanceof GregorianCalendar && start2.get(2) == 1 && start2.get(5) == 29) {
                        ++days;
                    }
                    start2.add(1, 1);
                    days += start2.get(6);
                }
                years = 0;
            }
            while (start2.get(2) != end2.get(2)) {
                days += start2.getActualMaximum(5);
                start2.add(2, 1);
            }
            months = 0;
            while (days < 0) {
                days += start2.getActualMaximum(5);
                --months;
                start2.add(2, 1);
            }
        }
        if (!Token.containsTokenWithValue(tokens, d)) {
            hours += 24 * days;
            days = 0;
        }
        if (!Token.containsTokenWithValue(tokens, H)) {
            minutes += 60 * hours;
            hours = 0;
        }
        if (!Token.containsTokenWithValue(tokens, m)) {
            seconds += 60 * minutes;
            minutes = 0;
        }
        if (!Token.containsTokenWithValue(tokens, s)) {
            milliseconds += 1000 * seconds;
            seconds = 0;
        }
        return DurationFormatUtils.format(tokens, years, months, days, hours, minutes, seconds, milliseconds, padWithZeros);
    }

    static String format(Token[] tokens, long years, long months, long days, long hours, long minutes, long seconds, long milliseconds, boolean padWithZeros) {
        StringBuilder buffer = new StringBuilder();
        boolean lastOutputSeconds = false;
        for (Token token : tokens) {
            Object value2 = token.getValue();
            int count2 = token.getCount();
            if (value2 instanceof StringBuilder) {
                buffer.append(value2.toString());
                continue;
            }
            if (value2 == y) {
                buffer.append(DurationFormatUtils.paddedValue(years, padWithZeros, count2));
                lastOutputSeconds = false;
                continue;
            }
            if (value2 == M) {
                buffer.append(DurationFormatUtils.paddedValue(months, padWithZeros, count2));
                lastOutputSeconds = false;
                continue;
            }
            if (value2 == d) {
                buffer.append(DurationFormatUtils.paddedValue(days, padWithZeros, count2));
                lastOutputSeconds = false;
                continue;
            }
            if (value2 == H) {
                buffer.append(DurationFormatUtils.paddedValue(hours, padWithZeros, count2));
                lastOutputSeconds = false;
                continue;
            }
            if (value2 == m) {
                buffer.append(DurationFormatUtils.paddedValue(minutes, padWithZeros, count2));
                lastOutputSeconds = false;
                continue;
            }
            if (value2 == s) {
                buffer.append(DurationFormatUtils.paddedValue(seconds, padWithZeros, count2));
                lastOutputSeconds = true;
                continue;
            }
            if (value2 != S) continue;
            if (lastOutputSeconds) {
                int width = padWithZeros ? Math.max(3, count2) : 3;
                buffer.append(DurationFormatUtils.paddedValue(milliseconds, true, width));
            } else {
                buffer.append(DurationFormatUtils.paddedValue(milliseconds, padWithZeros, count2));
            }
            lastOutputSeconds = false;
        }
        return buffer.toString();
    }

    private static String paddedValue(long value2, boolean padWithZeros, int count2) {
        String longString = Long.toString(value2);
        return padWithZeros ? StringUtils.leftPad(longString, count2, '0') : longString;
    }

    static Token[] lexx(String format) {
        ArrayList<Token> list2 = new ArrayList<Token>(format.length());
        boolean inLiteral = false;
        StringBuilder buffer = null;
        Token previous = null;
        for (int i2 = 0; i2 < format.length(); ++i2) {
            char ch = format.charAt(i2);
            if (inLiteral && ch != '\'') {
                buffer.append(ch);
                continue;
            }
            Object value2 = null;
            switch (ch) {
                case '\'': {
                    if (inLiteral) {
                        buffer = null;
                        inLiteral = false;
                        break;
                    }
                    buffer = new StringBuilder();
                    list2.add(new Token(buffer));
                    inLiteral = true;
                    break;
                }
                case 'y': {
                    value2 = y;
                    break;
                }
                case 'M': {
                    value2 = M;
                    break;
                }
                case 'd': {
                    value2 = d;
                    break;
                }
                case 'H': {
                    value2 = H;
                    break;
                }
                case 'm': {
                    value2 = m;
                    break;
                }
                case 's': {
                    value2 = s;
                    break;
                }
                case 'S': {
                    value2 = S;
                    break;
                }
                default: {
                    if (buffer == null) {
                        buffer = new StringBuilder();
                        list2.add(new Token(buffer));
                    }
                    buffer.append(ch);
                }
            }
            if (value2 == null) continue;
            if (previous != null && previous.getValue() == value2) {
                previous.increment();
            } else {
                Token token = new Token(value2);
                list2.add(token);
                previous = token;
            }
            buffer = null;
        }
        if (inLiteral) {
            throw new IllegalArgumentException("Unmatched quote in format: " + format);
        }
        return list2.toArray(new Token[list2.size()]);
    }

    static class Token {
        private final Object value;
        private int count;

        static boolean containsTokenWithValue(Token[] tokens, Object value2) {
            int sz = tokens.length;
            for (int i2 = 0; i2 < sz; ++i2) {
                if (tokens[i2].getValue() != value2) continue;
                return true;
            }
            return false;
        }

        Token(Object value2) {
            this.value = value2;
            this.count = 1;
        }

        Token(Object value2, int count2) {
            this.value = value2;
            this.count = count2;
        }

        void increment() {
            ++this.count;
        }

        int getCount() {
            return this.count;
        }

        Object getValue() {
            return this.value;
        }

        public boolean equals(Object obj2) {
            if (obj2 instanceof Token) {
                Token tok2 = (Token)obj2;
                if (this.value.getClass() != tok2.value.getClass()) {
                    return false;
                }
                if (this.count != tok2.count) {
                    return false;
                }
                if (this.value instanceof StringBuilder) {
                    return this.value.toString().equals(tok2.value.toString());
                }
                if (this.value instanceof Number) {
                    return this.value.equals(tok2.value);
                }
                return this.value == tok2.value;
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return StringUtils.repeat(this.value.toString(), this.count);
        }
    }
}

