/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.lf5;

import java.awt.Toolkit;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.lf5.AppenderFinalizer;
import org.apache.log4j.lf5.Log4JLogRecord;
import org.apache.log4j.lf5.LogLevel;
import org.apache.log4j.lf5.LogLevelFormatException;
import org.apache.log4j.lf5.viewer.LogBrokerMonitor;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

public class LF5Appender
extends AppenderSkeleton {
    protected LogBrokerMonitor _logMonitor;
    protected static LogBrokerMonitor _defaultLogMonitor;
    protected static AppenderFinalizer _finalizer;

    public LF5Appender() {
        this(LF5Appender.getDefaultInstance());
    }

    public LF5Appender(LogBrokerMonitor monitor) {
        if (monitor != null) {
            this._logMonitor = monitor;
        }
    }

    public void append(LoggingEvent event2) {
        String category = event2.getLoggerName();
        String logMessage = event2.getRenderedMessage();
        String nestedDiagnosticContext = event2.getNDC();
        String threadDescription = event2.getThreadName();
        String level2 = event2.getLevel().toString();
        long time = event2.timeStamp;
        LocationInfo locationInfo = event2.getLocationInformation();
        Log4JLogRecord record = new Log4JLogRecord();
        record.setCategory(category);
        record.setMessage(logMessage);
        record.setLocation(locationInfo.fullInfo);
        record.setMillis(time);
        record.setThreadDescription(threadDescription);
        if (nestedDiagnosticContext != null) {
            record.setNDC(nestedDiagnosticContext);
        } else {
            record.setNDC("");
        }
        if (event2.getThrowableInformation() != null) {
            record.setThrownStackTrace(event2.getThrowableInformation());
        }
        try {
            record.setLevel(LogLevel.valueOf(level2));
        }
        catch (LogLevelFormatException e) {
            record.setLevel(LogLevel.WARN);
        }
        if (this._logMonitor != null) {
            this._logMonitor.addMessage(record);
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    public void setCallSystemExitOnClose(boolean callSystemExitOnClose) {
        this._logMonitor.setCallSystemExitOnClose(callSystemExitOnClose);
    }

    public boolean equals(LF5Appender compareTo) {
        return this._logMonitor == compareTo.getLogBrokerMonitor();
    }

    public LogBrokerMonitor getLogBrokerMonitor() {
        return this._logMonitor;
    }

    public static void main(String[] args2) {
        new LF5Appender();
    }

    public void setMaxNumberOfRecords(int maxNumberOfRecords) {
        _defaultLogMonitor.setMaxNumberOfLogRecords(maxNumberOfRecords);
    }

    protected static synchronized LogBrokerMonitor getDefaultInstance() {
        if (_defaultLogMonitor == null) {
            try {
                _defaultLogMonitor = new LogBrokerMonitor(LogLevel.getLog4JLevels());
                _finalizer = new AppenderFinalizer(_defaultLogMonitor);
                _defaultLogMonitor.setFrameSize(LF5Appender.getDefaultMonitorWidth(), LF5Appender.getDefaultMonitorHeight());
                _defaultLogMonitor.setFontSize(12);
                _defaultLogMonitor.show();
            }
            catch (SecurityException e) {
                _defaultLogMonitor = null;
            }
        }
        return _defaultLogMonitor;
    }

    protected static int getScreenWidth() {
        try {
            return Toolkit.getDefaultToolkit().getScreenSize().width;
        }
        catch (Throwable t) {
            return 800;
        }
    }

    protected static int getScreenHeight() {
        try {
            return Toolkit.getDefaultToolkit().getScreenSize().height;
        }
        catch (Throwable t) {
            return 600;
        }
    }

    protected static int getDefaultMonitorWidth() {
        return 3 * LF5Appender.getScreenWidth() / 4;
    }

    protected static int getDefaultMonitorHeight() {
        return 3 * LF5Appender.getScreenHeight() / 4;
    }
}

