/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.nt;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.TTCCLayout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class NTEventLogAppender
extends AppenderSkeleton {
    private int _handle = 0;
    private String source = null;
    private String server = null;

    public NTEventLogAppender() {
        this(null, null, null);
    }

    public NTEventLogAppender(String source2) {
        this(null, source2, null);
    }

    public NTEventLogAppender(String server, String source2) {
        this(server, source2, null);
    }

    public NTEventLogAppender(Layout layout2) {
        this(null, null, layout2);
    }

    public NTEventLogAppender(String source2, Layout layout2) {
        this(null, source2, layout2);
    }

    public NTEventLogAppender(String server, String source2, Layout layout2) {
        if (source2 == null) {
            source2 = "Log4j";
        }
        this.layout = layout2 == null ? new TTCCLayout() : layout2;
        try {
            this._handle = this.registerEventSource(server, source2);
        }
        catch (Exception e) {
            e.printStackTrace();
            this._handle = 0;
        }
    }

    public void close() {
    }

    public void activateOptions() {
        if (this.source != null) {
            try {
                this._handle = this.registerEventSource(this.server, this.source);
            }
            catch (Exception e) {
                LogLog.error("Could not register event source.", e);
                this._handle = 0;
            }
        }
    }

    public void append(LoggingEvent event2) {
        String[] s2;
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.layout.format(event2));
        if (this.layout.ignoresThrowable() && (s2 = event2.getThrowableStrRep()) != null) {
            int len = s2.length;
            for (int i2 = 0; i2 < len; ++i2) {
                sbuf.append(s2[i2]);
            }
        }
        int nt_category = event2.getLevel().toInt();
        this.reportEvent(this._handle, sbuf.toString(), nt_category);
    }

    public void finalize() {
        this.deregisterEventSource(this._handle);
        this._handle = 0;
    }

    public void setSource(String source2) {
        this.source = source2.trim();
    }

    public String getSource() {
        return this.source;
    }

    public boolean requiresLayout() {
        return true;
    }

    private native int registerEventSource(String var1, String var2);

    private native void reportEvent(int var1, String var2, int var3);

    private native void deregisterEventSource(int var1);

    static {
        String[] archs;
        try {
            archs = new String[]{System.getProperty("os.arch")};
        }
        catch (SecurityException e) {
            archs = new String[]{"amd64", "ia64", "x86"};
        }
        boolean loaded = false;
        for (int i2 = 0; i2 < archs.length; ++i2) {
            try {
                System.loadLibrary("NTEventLogAppender." + archs[i2]);
                loaded = true;
                break;
            }
            catch (UnsatisfiedLinkError e) {
                loaded = false;
                continue;
            }
        }
        if (!loaded) {
            System.loadLibrary("NTEventLogAppender");
        }
    }
}

