/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.pattern;

import org.apache.log4j.pattern.LoggingEventPatternConverter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class ThrowableInformationPatternConverter
extends LoggingEventPatternConverter {
    private int maxLines = Integer.MAX_VALUE;

    private ThrowableInformationPatternConverter(String[] options2) {
        super("Throwable", "throwable");
        if (options2 != null && options2.length > 0) {
            if ("none".equals(options2[0])) {
                this.maxLines = 0;
            } else if ("short".equals(options2[0])) {
                this.maxLines = 1;
            } else {
                try {
                    this.maxLines = Integer.parseInt(options2[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public static ThrowableInformationPatternConverter newInstance(String[] options2) {
        return new ThrowableInformationPatternConverter(options2);
    }

    public void format(LoggingEvent event2, StringBuffer toAppendTo) {
        ThrowableInformation information;
        if (this.maxLines != 0 && (information = event2.getThrowableInformation()) != null) {
            String[] stringRep = information.getThrowableStrRep();
            int length2 = stringRep.length;
            if (this.maxLines < 0) {
                length2 += this.maxLines;
            } else if (length2 > this.maxLines) {
                length2 = this.maxLines;
            }
            for (int i2 = 0; i2 < length2; ++i2) {
                String string2 = stringRep[i2];
                toAppendTo.append(string2).append("\n");
            }
        }
    }

    public boolean handlesThrowable() {
        return true;
    }
}

