/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.jsoup.Connection;
import org.jsoup.HttpStatusException;
import org.jsoup.UnsupportedMimeTypeException;
import org.jsoup.helper.DataUtil;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;
import org.jsoup.parser.TokenQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpConnection
implements Connection {
    private static final int HTTP_TEMP_REDIR = 307;
    private Connection.Request req = new Request();
    private Connection.Response res = new Response();

    public static Connection connect(String url) {
        HttpConnection con = new HttpConnection();
        con.url(url);
        return con;
    }

    public static Connection connect(URL url) {
        HttpConnection con = new HttpConnection();
        con.url(url);
        return con;
    }

    private static String encodeUrl(String url) {
        if (url == null) {
            return null;
        }
        return url.replaceAll(" ", "%20");
    }

    private HttpConnection() {
    }

    @Override
    public Connection url(URL url) {
        this.req.url(url);
        return this;
    }

    @Override
    public Connection url(String url) {
        Validate.notEmpty(url, "Must supply a valid URL");
        try {
            this.req.url(new URL(HttpConnection.encodeUrl(url)));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed URL: " + url, e);
        }
        return this;
    }

    @Override
    public Connection userAgent(String userAgent) {
        Validate.notNull(userAgent, "User agent must not be null");
        this.req.header("User-Agent", userAgent);
        return this;
    }

    @Override
    public Connection timeout(int millis) {
        this.req.timeout(millis);
        return this;
    }

    @Override
    public Connection maxBodySize(int bytes2) {
        this.req.maxBodySize(bytes2);
        return this;
    }

    @Override
    public Connection followRedirects(boolean followRedirects) {
        this.req.followRedirects(followRedirects);
        return this;
    }

    @Override
    public Connection referrer(String referrer) {
        Validate.notNull(referrer, "Referrer must not be null");
        this.req.header("Referer", referrer);
        return this;
    }

    @Override
    public Connection method(Connection.Method method2) {
        this.req.method(method2);
        return this;
    }

    @Override
    public Connection ignoreHttpErrors(boolean ignoreHttpErrors) {
        this.req.ignoreHttpErrors(ignoreHttpErrors);
        return this;
    }

    @Override
    public Connection ignoreContentType(boolean ignoreContentType) {
        this.req.ignoreContentType(ignoreContentType);
        return this;
    }

    @Override
    public Connection data(String key2, String value2) {
        this.req.data(KeyVal.create(key2, value2));
        return this;
    }

    @Override
    public Connection data(Map<String, String> data2) {
        Validate.notNull(data2, "Data map must not be null");
        for (Map.Entry<String, String> entry : data2.entrySet()) {
            this.req.data(KeyVal.create(entry.getKey(), entry.getValue()));
        }
        return this;
    }

    @Override
    public Connection data(String ... keyvals) {
        Validate.notNull(keyvals, "Data key value pairs must not be null");
        Validate.isTrue(keyvals.length % 2 == 0, "Must supply an even number of key value pairs");
        for (int i2 = 0; i2 < keyvals.length; i2 += 2) {
            String key2 = keyvals[i2];
            String value2 = keyvals[i2 + 1];
            Validate.notEmpty(key2, "Data key must not be empty");
            Validate.notNull(value2, "Data value must not be null");
            this.req.data(KeyVal.create(key2, value2));
        }
        return this;
    }

    @Override
    public Connection data(Collection<Connection.KeyVal> data2) {
        Validate.notNull(data2, "Data collection must not be null");
        for (Connection.KeyVal entry : data2) {
            this.req.data(entry);
        }
        return this;
    }

    @Override
    public Connection header(String name2, String value2) {
        this.req.header(name2, value2);
        return this;
    }

    @Override
    public Connection cookie(String name2, String value2) {
        this.req.cookie(name2, value2);
        return this;
    }

    @Override
    public Connection cookies(Map<String, String> cookies) {
        Validate.notNull(cookies, "Cookie map must not be null");
        for (Map.Entry<String, String> entry : cookies.entrySet()) {
            this.req.cookie(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public Connection parser(Parser parser) {
        this.req.parser(parser);
        return this;
    }

    @Override
    public Document get() throws IOException {
        this.req.method(Connection.Method.GET);
        this.execute();
        return this.res.parse();
    }

    @Override
    public Document post() throws IOException {
        this.req.method(Connection.Method.POST);
        this.execute();
        return this.res.parse();
    }

    @Override
    public Connection.Response execute() throws IOException {
        this.res = Response.execute(this.req);
        return this.res;
    }

    @Override
    public Connection.Request request() {
        return this.req;
    }

    @Override
    public Connection request(Connection.Request request) {
        this.req = request;
        return this;
    }

    @Override
    public Connection.Response response() {
        return this.res;
    }

    @Override
    public Connection response(Connection.Response response) {
        this.res = response;
        return this;
    }

    public static class KeyVal
    implements Connection.KeyVal {
        private String key;
        private String value;

        public static KeyVal create(String key2, String value2) {
            Validate.notEmpty(key2, "Data key must not be empty");
            Validate.notNull(value2, "Data value must not be null");
            return new KeyVal(key2, value2);
        }

        private KeyVal(String key2, String value2) {
            this.key = key2;
            this.value = value2;
        }

        public KeyVal key(String key2) {
            Validate.notEmpty(key2, "Data key must not be empty");
            this.key = key2;
            return this;
        }

        public String key() {
            return this.key;
        }

        public KeyVal value(String value2) {
            Validate.notNull(value2, "Data value must not be null");
            this.value = value2;
            return this;
        }

        public String value() {
            return this.value;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Response
    extends Base<Connection.Response>
    implements Connection.Response {
        private static final int MAX_REDIRECTS = 20;
        private int statusCode;
        private String statusMessage;
        private ByteBuffer byteData;
        private String charset;
        private String contentType;
        private boolean executed = false;
        private int numRedirects = 0;
        private Connection.Request req;
        private static final Pattern xmlContentTypeRxp = Pattern.compile("application/\\w+\\+xml.*");

        Response() {
        }

        private Response(Response previousResponse) throws IOException {
            if (previousResponse != null) {
                this.numRedirects = previousResponse.numRedirects + 1;
                if (this.numRedirects >= 20) {
                    throw new IOException(String.format("Too many redirects occurred trying to load URL %s", previousResponse.url()));
                }
            }
        }

        static Response execute(Connection.Request req) throws IOException {
            return Response.execute(req, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Response execute(Connection.Request req, Response previousResponse) throws IOException {
            Response res;
            Validate.notNull(req, "Request must not be null");
            String protocol2 = req.url().getProtocol();
            if (!protocol2.equals("http") && !protocol2.equals("https")) {
                throw new MalformedURLException("Only http & https protocols supported");
            }
            if (req.method() == Connection.Method.GET && req.data().size() > 0) {
                Response.serialiseRequestUrl(req);
            }
            HttpURLConnection conn = Response.createConnection(req);
            try {
                conn.connect();
                if (req.method() == Connection.Method.POST) {
                    Response.writePost(req.data(), conn.getOutputStream());
                }
                int status2 = conn.getResponseCode();
                boolean needsRedirect = false;
                if (status2 != 200) {
                    if (status2 == 302 || status2 == 301 || status2 == 303 || status2 == 307) {
                        needsRedirect = true;
                    } else if (!req.ignoreHttpErrors()) {
                        throw new HttpStatusException("HTTP error fetching URL", status2, req.url().toString());
                    }
                }
                res = new Response(previousResponse);
                res.setupFromConnection(conn, previousResponse);
                if (needsRedirect && req.followRedirects()) {
                    req.method(Connection.Method.GET);
                    req.data().clear();
                    String location = res.header("Location");
                    if (location != null && location.startsWith("http:/") && location.charAt(6) != '/') {
                        location = location.substring(6);
                    }
                    req.url(new URL(req.url(), HttpConnection.encodeUrl(location)));
                    for (Map.Entry cookie : res.cookies.entrySet()) {
                        req.cookie((String)cookie.getKey(), (String)cookie.getValue());
                    }
                    Response i$ = Response.execute(req, res);
                    return i$;
                }
                res.req = req;
                String contentType = res.contentType();
                if (!(contentType == null || req.ignoreContentType() || contentType.startsWith("text/") || contentType.startsWith("application/xml") || xmlContentTypeRxp.matcher(contentType).matches())) {
                    throw new UnsupportedMimeTypeException("Unhandled content type. Must be text/*, application/xml, or application/xhtml+xml", contentType, req.url().toString());
                }
                InputStream bodyStream = null;
                InputStream dataStream = null;
                try {
                    dataStream = conn.getErrorStream() != null ? conn.getErrorStream() : conn.getInputStream();
                    bodyStream = res.hasHeader("Content-Encoding") && res.header("Content-Encoding").equalsIgnoreCase("gzip") ? new BufferedInputStream(new GZIPInputStream(dataStream)) : new BufferedInputStream(dataStream);
                    res.byteData = DataUtil.readToByteBuffer(bodyStream, req.maxBodySize());
                    res.charset = DataUtil.getCharsetFromContentType(res.contentType);
                }
                finally {
                    if (bodyStream != null) {
                        bodyStream.close();
                    }
                    if (dataStream != null) {
                        dataStream.close();
                    }
                }
            }
            finally {
                conn.disconnect();
            }
            res.executed = true;
            return res;
        }

        @Override
        public int statusCode() {
            return this.statusCode;
        }

        @Override
        public String statusMessage() {
            return this.statusMessage;
        }

        @Override
        public String charset() {
            return this.charset;
        }

        @Override
        public String contentType() {
            return this.contentType;
        }

        @Override
        public Document parse() throws IOException {
            Validate.isTrue(this.executed, "Request must be executed (with .execute(), .get(), or .post() before parsing response");
            Document doc = DataUtil.parseByteData(this.byteData, this.charset, this.url.toExternalForm(), this.req.parser());
            this.byteData.rewind();
            this.charset = doc.outputSettings().charset().name();
            return doc;
        }

        @Override
        public String body() {
            Validate.isTrue(this.executed, "Request must be executed (with .execute(), .get(), or .post() before getting response body");
            String body = this.charset == null ? Charset.forName("UTF-8").decode(this.byteData).toString() : Charset.forName(this.charset).decode(this.byteData).toString();
            this.byteData.rewind();
            return body;
        }

        @Override
        public byte[] bodyAsBytes() {
            Validate.isTrue(this.executed, "Request must be executed (with .execute(), .get(), or .post() before getting response body");
            return this.byteData.array();
        }

        private static HttpURLConnection createConnection(Connection.Request req) throws IOException {
            HttpURLConnection conn = (HttpURLConnection)req.url().openConnection();
            conn.setRequestMethod(req.method().name());
            conn.setInstanceFollowRedirects(false);
            conn.setConnectTimeout(req.timeout());
            conn.setReadTimeout(req.timeout());
            if (req.method() == Connection.Method.POST) {
                conn.setDoOutput(true);
            }
            if (req.cookies().size() > 0) {
                conn.addRequestProperty("Cookie", Response.getRequestCookieString(req));
            }
            for (Map.Entry<String, String> header : req.headers().entrySet()) {
                conn.addRequestProperty(header.getKey(), header.getValue());
            }
            return conn;
        }

        private void setupFromConnection(HttpURLConnection conn, Connection.Response previousResponse) throws IOException {
            this.method = Connection.Method.valueOf(conn.getRequestMethod());
            this.url = conn.getURL();
            this.statusCode = conn.getResponseCode();
            this.statusMessage = conn.getResponseMessage();
            this.contentType = conn.getContentType();
            Map<String, List<String>> resHeaders = conn.getHeaderFields();
            this.processResponseHeaders(resHeaders);
            if (previousResponse != null) {
                for (Map.Entry<String, String> prevCookie : previousResponse.cookies().entrySet()) {
                    if (this.hasCookie(prevCookie.getKey())) continue;
                    this.cookie(prevCookie.getKey(), prevCookie.getValue());
                }
            }
        }

        void processResponseHeaders(Map<String, List<String>> resHeaders) {
            for (Map.Entry<String, List<String>> entry : resHeaders.entrySet()) {
                String name2 = entry.getKey();
                if (name2 == null) continue;
                List<String> values2 = entry.getValue();
                if (name2.equalsIgnoreCase("Set-Cookie")) {
                    for (String value2 : values2) {
                        if (value2 == null) continue;
                        TokenQueue cd = new TokenQueue(value2);
                        String cookieName = cd.chompTo("=").trim();
                        String cookieVal = cd.consumeTo(";").trim();
                        if (cookieVal == null) {
                            cookieVal = "";
                        }
                        if (cookieName == null || cookieName.length() <= 0) continue;
                        this.cookie(cookieName, cookieVal);
                    }
                    continue;
                }
                if (values2.isEmpty()) continue;
                this.header(name2, values2.get(0));
            }
        }

        private static void writePost(Collection<Connection.KeyVal> data2, OutputStream outputStream) throws IOException {
            OutputStreamWriter w = new OutputStreamWriter(outputStream, "UTF-8");
            boolean first2 = true;
            for (Connection.KeyVal keyVal : data2) {
                if (!first2) {
                    w.append('&');
                } else {
                    first2 = false;
                }
                w.write(URLEncoder.encode(keyVal.key(), "UTF-8"));
                w.write(61);
                w.write(URLEncoder.encode(keyVal.value(), "UTF-8"));
            }
            w.close();
        }

        private static String getRequestCookieString(Connection.Request req) {
            StringBuilder sb = new StringBuilder();
            boolean first2 = true;
            for (Map.Entry<String, String> cookie : req.cookies().entrySet()) {
                if (!first2) {
                    sb.append("; ");
                } else {
                    first2 = false;
                }
                sb.append(cookie.getKey()).append('=').append(cookie.getValue());
            }
            return sb.toString();
        }

        private static void serialiseRequestUrl(Connection.Request req) throws IOException {
            URL in = req.url();
            StringBuilder url = new StringBuilder();
            boolean first2 = true;
            url.append(in.getProtocol()).append("://").append(in.getAuthority()).append(in.getPath()).append("?");
            if (in.getQuery() != null) {
                url.append(in.getQuery());
                first2 = false;
            }
            for (Connection.KeyVal keyVal : req.data()) {
                if (!first2) {
                    url.append('&');
                } else {
                    first2 = false;
                }
                url.append(URLEncoder.encode(keyVal.key(), "UTF-8")).append('=').append(URLEncoder.encode(keyVal.value(), "UTF-8"));
            }
            req.url(new URL(url.toString()));
            req.data().clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Request
    extends Base<Connection.Request>
    implements Connection.Request {
        private int timeoutMilliseconds = 3000;
        private int maxBodySizeBytes = 0x100000;
        private boolean followRedirects = true;
        private Collection<Connection.KeyVal> data = new ArrayList<Connection.KeyVal>();
        private boolean ignoreHttpErrors = false;
        private boolean ignoreContentType = false;
        private Parser parser;

        private Request() {
            this.method = Connection.Method.GET;
            this.headers.put("Accept-Encoding", "gzip");
            this.parser = Parser.htmlParser();
        }

        @Override
        public int timeout() {
            return this.timeoutMilliseconds;
        }

        @Override
        public Request timeout(int millis) {
            Validate.isTrue(millis >= 0, "Timeout milliseconds must be 0 (infinite) or greater");
            this.timeoutMilliseconds = millis;
            return this;
        }

        @Override
        public int maxBodySize() {
            return this.maxBodySizeBytes;
        }

        @Override
        public Connection.Request maxBodySize(int bytes2) {
            Validate.isTrue(bytes2 >= 0, "maxSize must be 0 (unlimited) or larger");
            this.maxBodySizeBytes = bytes2;
            return this;
        }

        @Override
        public boolean followRedirects() {
            return this.followRedirects;
        }

        @Override
        public Connection.Request followRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        @Override
        public boolean ignoreHttpErrors() {
            return this.ignoreHttpErrors;
        }

        @Override
        public Connection.Request ignoreHttpErrors(boolean ignoreHttpErrors) {
            this.ignoreHttpErrors = ignoreHttpErrors;
            return this;
        }

        @Override
        public boolean ignoreContentType() {
            return this.ignoreContentType;
        }

        @Override
        public Connection.Request ignoreContentType(boolean ignoreContentType) {
            this.ignoreContentType = ignoreContentType;
            return this;
        }

        @Override
        public Request data(Connection.KeyVal keyval) {
            Validate.notNull(keyval, "Key val must not be null");
            this.data.add(keyval);
            return this;
        }

        @Override
        public Collection<Connection.KeyVal> data() {
            return this.data;
        }

        @Override
        public Request parser(Parser parser) {
            this.parser = parser;
            return this;
        }

        @Override
        public Parser parser() {
            return this.parser;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Base<T extends Connection.Base>
    implements Connection.Base<T> {
        URL url;
        Connection.Method method;
        Map<String, String> headers = new LinkedHashMap<String, String>();
        Map<String, String> cookies = new LinkedHashMap<String, String>();

        private Base() {
        }

        @Override
        public URL url() {
            return this.url;
        }

        @Override
        public T url(URL url) {
            Validate.notNull(url, "URL must not be null");
            this.url = url;
            return (T)this;
        }

        @Override
        public Connection.Method method() {
            return this.method;
        }

        @Override
        public T method(Connection.Method method2) {
            Validate.notNull((Object)method2, "Method must not be null");
            this.method = method2;
            return (T)this;
        }

        @Override
        public String header(String name2) {
            Validate.notNull(name2, "Header name must not be null");
            return this.getHeaderCaseInsensitive(name2);
        }

        @Override
        public T header(String name2, String value2) {
            Validate.notEmpty(name2, "Header name must not be empty");
            Validate.notNull(value2, "Header value must not be null");
            this.removeHeader(name2);
            this.headers.put(name2, value2);
            return (T)this;
        }

        @Override
        public boolean hasHeader(String name2) {
            Validate.notEmpty(name2, "Header name must not be empty");
            return this.getHeaderCaseInsensitive(name2) != null;
        }

        @Override
        public T removeHeader(String name2) {
            Validate.notEmpty(name2, "Header name must not be empty");
            Map.Entry<String, String> entry = this.scanHeaders(name2);
            if (entry != null) {
                this.headers.remove(entry.getKey());
            }
            return (T)this;
        }

        @Override
        public Map<String, String> headers() {
            return this.headers;
        }

        private String getHeaderCaseInsensitive(String name2) {
            Map.Entry<String, String> entry;
            Validate.notNull(name2, "Header name must not be null");
            String value2 = this.headers.get(name2);
            if (value2 == null) {
                value2 = this.headers.get(name2.toLowerCase());
            }
            if (value2 == null && (entry = this.scanHeaders(name2)) != null) {
                value2 = entry.getValue();
            }
            return value2;
        }

        private Map.Entry<String, String> scanHeaders(String name2) {
            String lc = name2.toLowerCase();
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                if (!entry.getKey().toLowerCase().equals(lc)) continue;
                return entry;
            }
            return null;
        }

        @Override
        public String cookie(String name2) {
            Validate.notNull(name2, "Cookie name must not be null");
            return this.cookies.get(name2);
        }

        @Override
        public T cookie(String name2, String value2) {
            Validate.notEmpty(name2, "Cookie name must not be empty");
            Validate.notNull(value2, "Cookie value must not be null");
            this.cookies.put(name2, value2);
            return (T)this;
        }

        @Override
        public boolean hasCookie(String name2) {
            Validate.notEmpty("Cookie name must not be empty");
            return this.cookies.containsKey(name2);
        }

        @Override
        public T removeCookie(String name2) {
            Validate.notEmpty("Cookie name must not be empty");
            this.cookies.remove(name2);
            return (T)this;
        }

        @Override
        public Map<String, String> cookies() {
            return this.cookies;
        }
    }
}

