/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jsoup.helper.DescendableLinkedList;
import org.jsoup.helper.StringUtil;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.FormElement;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.HtmlTreeBuilderState;
import org.jsoup.parser.ParseError;
import org.jsoup.parser.ParseErrorList;
import org.jsoup.parser.Tag;
import org.jsoup.parser.Token;
import org.jsoup.parser.TokeniserState;
import org.jsoup.parser.TreeBuilder;
import org.jsoup.select.Elements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlTreeBuilder
extends TreeBuilder {
    private static final String[] TagsScriptStyle = new String[]{"script", "style"};
    public static final String[] TagsSearchInScope = new String[]{"applet", "caption", "html", "table", "td", "th", "marquee", "object"};
    private static final String[] TagSearchList = new String[]{"ol", "ul"};
    private static final String[] TagSearchButton = new String[]{"button"};
    private static final String[] TagSearchTableScope = new String[]{"html", "table"};
    private static final String[] TagSearchSelectScope = new String[]{"optgroup", "option"};
    private static final String[] TagSearchEndTags = new String[]{"dd", "dt", "li", "option", "optgroup", "p", "rp", "rt"};
    private static final String[] TagSearchSpecial = new String[]{"address", "applet", "area", "article", "aside", "base", "basefont", "bgsound", "blockquote", "body", "br", "button", "caption", "center", "col", "colgroup", "command", "dd", "details", "dir", "div", "dl", "dt", "embed", "fieldset", "figcaption", "figure", "footer", "form", "frame", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "iframe", "img", "input", "isindex", "li", "link", "listing", "marquee", "menu", "meta", "nav", "noembed", "noframes", "noscript", "object", "ol", "p", "param", "plaintext", "pre", "script", "section", "select", "style", "summary", "table", "tbody", "td", "textarea", "tfoot", "th", "thead", "title", "tr", "ul", "wbr", "xmp"};
    private HtmlTreeBuilderState state;
    private HtmlTreeBuilderState originalState;
    private boolean baseUriSetFromDoc = false;
    private Element headElement;
    private FormElement formElement;
    private Element contextElement;
    private DescendableLinkedList<Element> formattingElements = new DescendableLinkedList();
    private List<Token.Character> pendingTableCharacters = new ArrayList<Token.Character>();
    private boolean framesetOk = true;
    private boolean fosterInserts = false;
    private boolean fragmentParsing = false;

    HtmlTreeBuilder() {
    }

    @Override
    Document parse(String input, String baseUri, ParseErrorList errors) {
        this.state = HtmlTreeBuilderState.Initial;
        this.baseUriSetFromDoc = false;
        return super.parse(input, baseUri, errors);
    }

    List<Node> parseFragment(String inputFragment, Element context, String baseUri, ParseErrorList errors) {
        this.state = HtmlTreeBuilderState.Initial;
        this.initialiseParse(inputFragment, baseUri, errors);
        this.contextElement = context;
        this.fragmentParsing = true;
        Node root = null;
        if (context != null) {
            if (context.ownerDocument() != null) {
                this.doc.quirksMode(context.ownerDocument().quirksMode());
            }
            String contextTag = context.tagName();
            if (StringUtil.in(contextTag, "title", "textarea")) {
                this.tokeniser.transition(TokeniserState.Rcdata);
            } else if (StringUtil.in(contextTag, "iframe", "noembed", "noframes", "style", "xmp")) {
                this.tokeniser.transition(TokeniserState.Rawtext);
            } else if (contextTag.equals("script")) {
                this.tokeniser.transition(TokeniserState.ScriptData);
            } else if (contextTag.equals("noscript")) {
                this.tokeniser.transition(TokeniserState.Data);
            } else if (contextTag.equals("plaintext")) {
                this.tokeniser.transition(TokeniserState.Data);
            } else {
                this.tokeniser.transition(TokeniserState.Data);
            }
            root = new Element(Tag.valueOf("html"), baseUri);
            this.doc.appendChild(root);
            this.stack.push(root);
            this.resetInsertionMode();
            Elements contextChain = context.parents();
            contextChain.add(0, context);
            for (Element parent : contextChain) {
                if (!(parent instanceof FormElement)) continue;
                this.formElement = (FormElement)parent;
                break;
            }
        }
        this.runParser();
        if (context != null) {
            return root.childNodes();
        }
        return this.doc.childNodes();
    }

    @Override
    protected boolean process(Token token) {
        this.currentToken = token;
        return this.state.process(token, this);
    }

    boolean process(Token token, HtmlTreeBuilderState state2) {
        this.currentToken = token;
        return state2.process(token, this);
    }

    void transition(HtmlTreeBuilderState state2) {
        this.state = state2;
    }

    HtmlTreeBuilderState state() {
        return this.state;
    }

    void markInsertionMode() {
        this.originalState = this.state;
    }

    HtmlTreeBuilderState originalState() {
        return this.originalState;
    }

    void framesetOk(boolean framesetOk) {
        this.framesetOk = framesetOk;
    }

    boolean framesetOk() {
        return this.framesetOk;
    }

    Document getDocument() {
        return this.doc;
    }

    String getBaseUri() {
        return this.baseUri;
    }

    void maybeSetBaseUri(Element base) {
        if (this.baseUriSetFromDoc) {
            return;
        }
        String href = base.absUrl("href");
        if (href.length() != 0) {
            this.baseUri = href;
            this.baseUriSetFromDoc = true;
            this.doc.setBaseUri(href);
        }
    }

    boolean isFragmentParsing() {
        return this.fragmentParsing;
    }

    void error(HtmlTreeBuilderState state2) {
        if (this.errors.canAddError()) {
            this.errors.add(new ParseError(this.reader.pos(), "Unexpected token [%s] when in state [%s]", new Object[]{this.currentToken.tokenType(), state2}));
        }
    }

    Element insert(Token.StartTag startTag) {
        if (startTag.isSelfClosing()) {
            Element el = this.insertEmpty(startTag);
            this.stack.add(el);
            this.tokeniser.transition(TokeniserState.Data);
            this.tokeniser.emit(new Token.EndTag(el.tagName()));
            return el;
        }
        Element el = new Element(Tag.valueOf(startTag.name()), this.baseUri, startTag.attributes);
        this.insert(el);
        return el;
    }

    Element insert(String startTagName) {
        Element el = new Element(Tag.valueOf(startTagName), this.baseUri);
        this.insert(el);
        return el;
    }

    void insert(Element el) {
        this.insertNode(el);
        this.stack.add(el);
    }

    Element insertEmpty(Token.StartTag startTag) {
        Tag tag2 = Tag.valueOf(startTag.name());
        Element el = new Element(tag2, this.baseUri, startTag.attributes);
        this.insertNode(el);
        if (startTag.isSelfClosing()) {
            if (tag2.isKnownTag()) {
                if (tag2.isSelfClosing()) {
                    this.tokeniser.acknowledgeSelfClosingFlag();
                }
            } else {
                tag2.setSelfClosing();
                this.tokeniser.acknowledgeSelfClosingFlag();
            }
        }
        return el;
    }

    FormElement insertForm(Token.StartTag startTag, boolean onStack) {
        Tag tag2 = Tag.valueOf(startTag.name());
        FormElement el = new FormElement(tag2, this.baseUri, startTag.attributes);
        this.setFormElement(el);
        this.insertNode(el);
        if (onStack) {
            this.stack.add(el);
        }
        return el;
    }

    void insert(Token.Comment commentToken) {
        Comment comment2 = new Comment(commentToken.getData(), this.baseUri);
        this.insertNode(comment2);
    }

    void insert(Token.Character characterToken) {
        String tagName = this.currentElement().tagName();
        Node node = tagName.equals("script") || tagName.equals("style") ? new DataNode(characterToken.getData(), this.baseUri) : new TextNode(characterToken.getData(), this.baseUri);
        this.currentElement().appendChild(node);
    }

    private void insertNode(Node node) {
        if (this.stack.size() == 0) {
            this.doc.appendChild(node);
        } else if (this.isFosterInserts()) {
            this.insertInFosterParent(node);
        } else {
            this.currentElement().appendChild(node);
        }
        if (node instanceof Element && ((Element)node).tag().isFormListed() && this.formElement != null) {
            this.formElement.addElement((Element)node);
        }
    }

    Element pop() {
        if (((Element)this.stack.peekLast()).nodeName().equals("td") && !this.state.name().equals("InCell")) {
            Validate.isFalse(true, "pop td not in cell");
        }
        if (((Element)this.stack.peekLast()).nodeName().equals("html")) {
            Validate.isFalse(true, "popping html!");
        }
        return (Element)this.stack.pollLast();
    }

    void push(Element element) {
        this.stack.add(element);
    }

    DescendableLinkedList<Element> getStack() {
        return this.stack;
    }

    boolean onStack(Element el) {
        return this.isElementInQueue(this.stack, el);
    }

    private boolean isElementInQueue(DescendableLinkedList<Element> queue, Element element) {
        Iterator<Element> it = queue.descendingIterator();
        while (it.hasNext()) {
            Element next2 = it.next();
            if (next2 != element) continue;
            return true;
        }
        return false;
    }

    Element getFromStack(String elName) {
        Iterator it = this.stack.descendingIterator();
        while (it.hasNext()) {
            Element next2 = (Element)it.next();
            if (!next2.nodeName().equals(elName)) continue;
            return next2;
        }
        return null;
    }

    boolean removeFromStack(Element el) {
        Iterator it = this.stack.descendingIterator();
        while (it.hasNext()) {
            Element next2 = (Element)it.next();
            if (next2 != el) continue;
            it.remove();
            return true;
        }
        return false;
    }

    void popStackToClose(String elName) {
        Iterator it = this.stack.descendingIterator();
        while (it.hasNext()) {
            Element next2 = (Element)it.next();
            if (next2.nodeName().equals(elName)) {
                it.remove();
                break;
            }
            it.remove();
        }
    }

    void popStackToClose(String ... elNames) {
        Iterator it = this.stack.descendingIterator();
        while (it.hasNext()) {
            Element next2 = (Element)it.next();
            if (StringUtil.in(next2.nodeName(), elNames)) {
                it.remove();
                break;
            }
            it.remove();
        }
    }

    void popStackToBefore(String elName) {
        Element next2;
        Iterator it = this.stack.descendingIterator();
        while (it.hasNext() && !(next2 = (Element)it.next()).nodeName().equals(elName)) {
            it.remove();
        }
    }

    void clearStackToTableContext() {
        this.clearStackToContext("table");
    }

    void clearStackToTableBodyContext() {
        this.clearStackToContext("tbody", "tfoot", "thead");
    }

    void clearStackToTableRowContext() {
        this.clearStackToContext("tr");
    }

    private void clearStackToContext(String ... nodeNames) {
        Element next2;
        Iterator it = this.stack.descendingIterator();
        while (it.hasNext() && !StringUtil.in((next2 = (Element)it.next()).nodeName(), nodeNames) && !next2.nodeName().equals("html")) {
            it.remove();
        }
    }

    Element aboveOnStack(Element el) {
        assert (this.onStack(el));
        Iterator it = this.stack.descendingIterator();
        while (it.hasNext()) {
            Element next2 = (Element)it.next();
            if (next2 != el) continue;
            return (Element)it.next();
        }
        return null;
    }

    void insertOnStackAfter(Element after, Element in) {
        int i2 = this.stack.lastIndexOf(after);
        Validate.isTrue(i2 != -1);
        this.stack.add(i2 + 1, in);
    }

    void replaceOnStack(Element out, Element in) {
        this.replaceInQueue(this.stack, out, in);
    }

    private void replaceInQueue(LinkedList<Element> queue, Element out, Element in) {
        int i2 = queue.lastIndexOf(out);
        Validate.isTrue(i2 != -1);
        queue.remove(i2);
        queue.add(i2, in);
    }

    void resetInsertionMode() {
        boolean last2 = false;
        Iterator it = this.stack.descendingIterator();
        while (it.hasNext()) {
            String name2;
            Element node = (Element)it.next();
            if (!it.hasNext()) {
                last2 = true;
                node = this.contextElement;
            }
            if ("select".equals(name2 = node.nodeName())) {
                this.transition(HtmlTreeBuilderState.InSelect);
                break;
            }
            if ("td".equals(name2) || "td".equals(name2) && !last2) {
                this.transition(HtmlTreeBuilderState.InCell);
                break;
            }
            if ("tr".equals(name2)) {
                this.transition(HtmlTreeBuilderState.InRow);
                break;
            }
            if ("tbody".equals(name2) || "thead".equals(name2) || "tfoot".equals(name2)) {
                this.transition(HtmlTreeBuilderState.InTableBody);
                break;
            }
            if ("caption".equals(name2)) {
                this.transition(HtmlTreeBuilderState.InCaption);
                break;
            }
            if ("colgroup".equals(name2)) {
                this.transition(HtmlTreeBuilderState.InColumnGroup);
                break;
            }
            if ("table".equals(name2)) {
                this.transition(HtmlTreeBuilderState.InTable);
                break;
            }
            if ("head".equals(name2)) {
                this.transition(HtmlTreeBuilderState.InBody);
                break;
            }
            if ("body".equals(name2)) {
                this.transition(HtmlTreeBuilderState.InBody);
                break;
            }
            if ("frameset".equals(name2)) {
                this.transition(HtmlTreeBuilderState.InFrameset);
                break;
            }
            if ("html".equals(name2)) {
                this.transition(HtmlTreeBuilderState.BeforeHead);
                break;
            }
            if (!last2) continue;
            this.transition(HtmlTreeBuilderState.InBody);
            break;
        }
    }

    private boolean inSpecificScope(String targetName, String[] baseTypes, String[] extraTypes) {
        return this.inSpecificScope(new String[]{targetName}, baseTypes, extraTypes);
    }

    private boolean inSpecificScope(String[] targetNames, String[] baseTypes, String[] extraTypes) {
        Iterator it = this.stack.descendingIterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            String elName = el.nodeName();
            if (StringUtil.in(elName, targetNames)) {
                return true;
            }
            if (StringUtil.in(elName, baseTypes)) {
                return false;
            }
            if (extraTypes == null || !StringUtil.in(elName, extraTypes)) continue;
            return false;
        }
        Validate.fail("Should not be reachable");
        return false;
    }

    boolean inScope(String[] targetNames) {
        return this.inSpecificScope(targetNames, TagsSearchInScope, null);
    }

    boolean inScope(String targetName) {
        return this.inScope(targetName, null);
    }

    boolean inScope(String targetName, String[] extras) {
        return this.inSpecificScope(targetName, TagsSearchInScope, extras);
    }

    boolean inListItemScope(String targetName) {
        return this.inScope(targetName, TagSearchList);
    }

    boolean inButtonScope(String targetName) {
        return this.inScope(targetName, TagSearchButton);
    }

    boolean inTableScope(String targetName) {
        return this.inSpecificScope(targetName, TagSearchTableScope, null);
    }

    boolean inSelectScope(String targetName) {
        Iterator it = this.stack.descendingIterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            String elName = el.nodeName();
            if (elName.equals(targetName)) {
                return true;
            }
            if (StringUtil.in(elName, TagSearchSelectScope)) continue;
            return false;
        }
        Validate.fail("Should not be reachable");
        return false;
    }

    void setHeadElement(Element headElement) {
        this.headElement = headElement;
    }

    Element getHeadElement() {
        return this.headElement;
    }

    boolean isFosterInserts() {
        return this.fosterInserts;
    }

    void setFosterInserts(boolean fosterInserts) {
        this.fosterInserts = fosterInserts;
    }

    FormElement getFormElement() {
        return this.formElement;
    }

    void setFormElement(FormElement formElement) {
        this.formElement = formElement;
    }

    void newPendingTableCharacters() {
        this.pendingTableCharacters = new ArrayList<Token.Character>();
    }

    List<Token.Character> getPendingTableCharacters() {
        return this.pendingTableCharacters;
    }

    void setPendingTableCharacters(List<Token.Character> pendingTableCharacters) {
        this.pendingTableCharacters = pendingTableCharacters;
    }

    void generateImpliedEndTags(String excludeTag) {
        while (excludeTag != null && !this.currentElement().nodeName().equals(excludeTag) && StringUtil.in(this.currentElement().nodeName(), TagSearchEndTags)) {
            this.pop();
        }
    }

    void generateImpliedEndTags() {
        this.generateImpliedEndTags(null);
    }

    boolean isSpecial(Element el) {
        String name2 = el.nodeName();
        return StringUtil.in(name2, TagSearchSpecial);
    }

    void pushActiveFormattingElements(Element in) {
        Element el;
        int numSeen = 0;
        Iterator<Element> iter = this.formattingElements.descendingIterator();
        while (iter.hasNext() && (el = iter.next()) != null) {
            if (this.isSameFormattingElement(in, el)) {
                ++numSeen;
            }
            if (numSeen != 3) continue;
            iter.remove();
            break;
        }
        this.formattingElements.add(in);
    }

    private boolean isSameFormattingElement(Element a, Element b2) {
        return a.nodeName().equals(b2.nodeName()) && a.attributes().equals(b2.attributes());
    }

    void reconstructFormattingElements() {
        int size2 = this.formattingElements.size();
        if (size2 == 0 || this.formattingElements.getLast() == null || this.onStack((Element)this.formattingElements.getLast())) {
            return;
        }
        Element entry = (Element)this.formattingElements.getLast();
        int pos2 = size2 - 1;
        boolean skip2 = false;
        do {
            if (pos2 != 0) continue;
            skip2 = true;
            break;
        } while ((entry = (Element)this.formattingElements.get(--pos2)) != null && !this.onStack(entry));
        do {
            if (!skip2) {
                entry = (Element)this.formattingElements.get(++pos2);
            }
            Validate.notNull(entry);
            skip2 = false;
            Element newEl = this.insert(entry.nodeName());
            newEl.attributes().addAll(entry.attributes());
            this.formattingElements.add(pos2, newEl);
            this.formattingElements.remove(pos2 + 1);
        } while (pos2 != size2 - 1);
    }

    void clearFormattingElementsToLastMarker() {
        while (!this.formattingElements.isEmpty()) {
            Element el = this.formattingElements.peekLast();
            this.formattingElements.removeLast();
            if (el != null) continue;
            break;
        }
    }

    void removeFromActiveFormattingElements(Element el) {
        Iterator<Element> it = this.formattingElements.descendingIterator();
        while (it.hasNext()) {
            Element next2 = it.next();
            if (next2 != el) continue;
            it.remove();
            break;
        }
    }

    boolean isInActiveFormattingElements(Element el) {
        return this.isElementInQueue(this.formattingElements, el);
    }

    Element getActiveFormattingElement(String nodeName) {
        Element next2;
        Iterator<Element> it = this.formattingElements.descendingIterator();
        while (it.hasNext() && (next2 = it.next()) != null) {
            if (!next2.nodeName().equals(nodeName)) continue;
            return next2;
        }
        return null;
    }

    void replaceActiveFormattingElement(Element out, Element in) {
        this.replaceInQueue(this.formattingElements, out, in);
    }

    void insertMarkerToFormattingElements() {
        this.formattingElements.add(null);
    }

    void insertInFosterParent(Node in) {
        Element fosterParent = null;
        Element lastTable = this.getFromStack("table");
        boolean isLastTableParent = false;
        if (lastTable != null) {
            if (lastTable.parent() != null) {
                fosterParent = lastTable.parent();
                isLastTableParent = true;
            } else {
                fosterParent = this.aboveOnStack(lastTable);
            }
        } else {
            fosterParent = (Element)this.stack.get(0);
        }
        if (isLastTableParent) {
            Validate.notNull(lastTable);
            lastTable.before(in);
        } else {
            fosterParent.appendChild(in);
        }
    }

    public String toString() {
        return "TreeBuilder{currentToken=" + this.currentToken + ", state=" + (Object)((Object)this.state) + ", currentElement=" + this.currentElement() + '}';
    }
}

