/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.documentation.builder;

import com.mulesoft.documentation.builder.model.TocNode;
import com.mulesoft.documentation.builder.util.Utilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SectionTocHtml {
    private static Logger logger = LoggerFactory.getLogger(SectionTocHtml.class);
    private String html;

    public SectionTocHtml(String html) {
        this.html = html;
    }

    public static SectionTocHtml getUnselectedTocFromRootNode(TocNode rootNode, String baseUrl) {
        return SectionTocHtml.getTocFromRootNode(rootNode, null, baseUrl);
    }

    public static SectionTocHtml getSelectedTocFromRootNode(TocNode rootNode, String url, String baseUrl) {
        return SectionTocHtml.getTocFromRootNode(rootNode, url, baseUrl);
    }

    private static SectionTocHtml getTocFromRootNode(TocNode rootNode, String url, String baseUrl) {
        SectionTocHtml.validateInputParams(new Object[]{rootNode});
        StringBuilder builder = new StringBuilder();
        if (url != null) {
            Utilities.validateIfActiveUrlIsInSection(rootNode, url);
        }
        SectionTocHtml.generateTocHtml(rootNode, builder, true, url, baseUrl);
        return new SectionTocHtml(builder.toString());
    }

    public String getHtml() {
        return this.html;
    }

    private static void generateTocHtml(TocNode parent, StringBuilder html, boolean isFirstItem, String activeUrl, String baseUrl) {
        String closed = "<li>\n<i></i>\n<a href=\"" + SectionTocHtml.getCompleteUrl(baseUrl, parent.getUrl()) + "\">" + parent.getTitle() + "</a><ul>\n";
        String opened = "<li class=\"expanded\">\n<i></i>\n<a href=\"" + SectionTocHtml.getCompleteUrl(baseUrl, parent.getUrl()) + "\">" + parent.getTitle() + "</a><ul style=\"display: block;\">\n";
        String selected = "<li class=\"active expanded\">\n<i></i>\n<a href=\"" + SectionTocHtml.getCompleteUrl(baseUrl, parent.getUrl()) + "\">" + parent.getTitle() + "</a><ul style=\"display: block;\">\n";
        if (activeUrl != null) {
            if (parent.getUrl().equalsIgnoreCase(activeUrl)) {
                html.append(selected);
            } else if (isFirstItem && !activeUrl.isEmpty()) {
                html.append(opened);
            } else if (Utilities.isActiveUrlInSection(parent, activeUrl, false)) {
                html.append(opened);
            } else {
                html.append(closed);
            }
        } else {
            html.append(closed);
        }
        if (parent.getChildren().size() == 0) {
            return;
        }
        SectionTocHtml.getHtmlForChildren(parent, html, activeUrl, baseUrl);
        html.append("</ul></li>\n");
    }

    private static void getHtmlForChildren(TocNode parent, StringBuilder html, String activeUrl, String baseUrl) {
        for (TocNode child : parent.getChildren()) {
            if (child.getChildren().size() > 0) {
                SectionTocHtml.generateTocHtml(child, html, false, activeUrl, baseUrl);
                continue;
            }
            html.append("<li");
            if (activeUrl != null && activeUrl.equalsIgnoreCase(child.getUrl())) {
                html.append(" class=\"active\"");
            }
            html.append("><i></i><a href=\"" + SectionTocHtml.getCompleteUrl(baseUrl, child.getUrl()) + "\">");
            html.append(child.getTitle() + "</a></li>");
        }
    }

    private static String getCompleteUrl(String baseUrl, String url) {
        return Utilities.getConcatPath(new String[]{baseUrl, url});
    }

    private static void validateInputParams(Object[] params) {
        Utilities.validateCtorObjectsAreNotNull(params, SectionTocHtml.class.getSimpleName());
    }
}

