/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.documentation.builder;

import com.mulesoft.documentation.builder.AsciiDocPage;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.safety.Whitelist;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwiftTypeMetadata {
    private static Logger logger = LoggerFactory.getLogger(SwiftTypeMetadata.class);

    public static String fromAsciiDocPage(AsciiDocPage page) {
        return SwiftTypeMetadata.getMetadataEntries(page);
    }

    public static String getMetadataEntries(AsciiDocPage page) {
        logger.debug("Creating SwiftType metadata for page \"" + page.getTitle() + "\"...");
        String result = "";
        result = result + SwiftTypeMetadata.getTitleMetadata(page);
        return result;
    }

    public static String getTitleMetadata(AsciiDocPage page) {
        String result = "<meta class=\"swiftype\" name=\"title\" data-type=\"string\" content=";
        result = result + "\"" + page.getTitle().trim() + "\" />\n";
        return result;
    }

    public static String getBodyMetadata(AsciiDocPage page) {
        String bodyText = SwiftTypeMetadata.getDescription(page);
        if (bodyText.length() > 0) {
            String result = "    <meta class=\"swiftype\" name=\"body\" data-type=\"text\" content=";
            result = result + "\"" + bodyText + "\" />\n";
            return result;
        }
        return "";
    }

    public static String getDescription(AsciiDocPage page) {
        String result = "";
        Document doc = Jsoup.parse((String)page.getHtml(), (String)"UTF-8");
        Elements paragraphs = doc.getElementsByClass("paragraph");
        if (paragraphs != null && paragraphs.size() > 0) {
            result = SwiftTypeMetadata.getShortenedDescription((List<Element>)paragraphs);
        }
        return result;
    }

    private static String getShortenedDescription(List<Element> paragraphs) {
        int max;
        String result = "";
        for (Element para : paragraphs) {
            result = result + Jsoup.clean((String)para.html(), (Whitelist)Whitelist.none());
            if ((result = result + " ").length() < 147) continue;
            break;
        }
        result = (max = result.length()) < 147 ? result.substring(0, max) : result.substring(0, 147);
        result = SwiftTypeMetadata.formatEndOfDescriptionTag(result);
        result = StringEscapeUtils.unescapeHtml4((String)result);
        return result;
    }

    private static String formatEndOfDescriptionTag(String text) {
        if (text.endsWith(".")) {
            text = text + "..";
        } else if (text.endsWith(",") || text.endsWith(";") || text.endsWith(":") || text.endsWith("'") || text.endsWith("\"") || text.endsWith("-") || text.endsWith("--")) {
            int length = text.length();
            text = text.substring(0, length - 2) + "...";
        } else {
            text = text + "...";
        }
        return text;
    }
}

