/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.documentation.builder;

import com.mulesoft.documentation.builder.AsciiDocPage;
import com.mulesoft.documentation.builder.Section;
import com.mulesoft.documentation.builder.SectionTocHtml;
import com.mulesoft.documentation.builder.SiteTableOfContents;
import com.mulesoft.documentation.builder.model.TocNode;
import com.mulesoft.documentation.builder.util.Utilities;
import java.util.ArrayList;
import java.util.List;

public class SiteTocHtml {
    private SiteTableOfContents toc;
    private List<Section> sections;

    public SiteTocHtml(SiteTableOfContents toc, List<Section> sections) {
        this.toc = toc;
        this.sections = sections;
    }

    public static SiteTocHtml fromSiteTocAndSections(SiteTableOfContents toc, List<Section> sections) {
        return new SiteTocHtml(toc, sections);
    }

    public void getTocHtmlForSectionAndPage2(Section section, AsciiDocPage page) {
        StringBuilder builder = new StringBuilder();
        for (TocNode node : this.toc.getNodes()) {
            if (!node.getUrl().equals(section.getBaseName())) continue;
            String fixedBaseName = Utilities.fixIndexBaseName(page.getBaseName());
            if (Utilities.isActiveUrlInSection(section.getRootNode(), fixedBaseName, false)) {
                builder.append(this.getSelectedSectionHtml(section, page));
                continue;
            }
            builder.append(this.getUnselectedSectionHtml(section));
        }
        String fixedBaseName = Utilities.fixIndexBaseName(page.getBaseName());
        if (Utilities.isActiveUrlInSection(section.getRootNode(), fixedBaseName, false)) {
            builder.append(this.getSelectedSectionHtml(section, page));
        } else {
            builder.append(this.getUnselectedSectionHtml(section));
        }
    }

    public String getTocHtmlForSectionAndPage(Section section, AsciiDocPage page) {
        ArrayList<String> alreadyAddedSectionBaseNames = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        for (TocNode node : this.toc.getNodes()) {
            for (Section currentSection : this.sections) {
                if (currentSection.getBaseName().equals(section.getBaseName())) {
                    if (!currentSection.getUrl().equals(section.getUrl()) || !node.getUrl().equals(section.getBaseName())) continue;
                    String fixedBaseName = Utilities.fixIndexBaseName(page.getBaseName());
                    if (Utilities.isActiveUrlInSection(section.getRootNode(), fixedBaseName, false) && !alreadyAddedSectionBaseNames.contains(currentSection.getBaseName())) {
                        builder.append(this.getSelectedSectionHtml(section, page));
                        alreadyAddedSectionBaseNames.add(currentSection.getBaseName());
                        continue;
                    }
                    if (alreadyAddedSectionBaseNames.contains(currentSection.getBaseName())) continue;
                    builder.append(this.getUnselectedSectionHtml(currentSection));
                    alreadyAddedSectionBaseNames.add(currentSection.getBaseName());
                    continue;
                }
                if (currentSection.getBaseName().equals(section.getBaseName())) continue;
                for (Section s : this.sections) {
                    if (!s.getBaseName().equals(node.getUrl()) || !s.getSectionVersion().isLatestVersion() || alreadyAddedSectionBaseNames.contains(s.getBaseName()) || s.getBaseName().equals(section.getBaseName())) continue;
                    builder.append(this.getUnselectedSectionHtml(s));
                    alreadyAddedSectionBaseNames.add(s.getBaseName());
                }
            }
        }
        return builder.toString();
    }

    private String getSelectedSectionHtml(Section section, AsciiDocPage page) {
        String pageUrl = Utilities.fixIndexBaseName(page.getBaseName());
        return SectionTocHtml.getSelectedTocFromRootNode(section.getRootNode(), pageUrl, "/" + section.getUrl()).getHtml();
    }

    private String getUnselectedSectionHtml(Section section) {
        return SectionTocHtml.getUnselectedTocFromRootNode(section.getRootNode(), "/" + section.getUrl()).getHtml();
    }
}

