/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.documentation.builder;

import com.mulesoft.documentation.builder.DocBuildException;
import com.mulesoft.documentation.builder.TemplateType;
import com.mulesoft.documentation.builder.util.Utilities;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class Template {
    private String contents;
    private TemplateType type;

    public Template(String contents, TemplateType type) {
        this.contents = contents;
        this.type = type;
    }

    public static List<Template> fromDirectory(File directory) {
        ArrayList<Template> templates = new ArrayList<Template>();
        Utilities.validateIsDirectory(directory);
        for (File templateFile : directory.listFiles()) {
            if (!FilenameUtils.getExtension((String)templateFile.getName()).equals("template")) continue;
            templates.add(Template.fromFile(templateFile));
        }
        return templates;
    }

    public static Template fromString(TemplateType type, String contents) {
        return new Template(contents, type);
    }

    public static Template fromFile(File file) {
        Utilities.validateTemplateFile(file);
        String contents = Template.getTemplateContents(file);
        TemplateType type = Template.getTemplateType(file);
        return new Template(contents, type);
    }

    private static String getTemplateContents(File file) {
        return Utilities.getFileContentsFromFile(file);
    }

    private static TemplateType getTemplateType(File file) {
        String baseName = FilenameUtils.getBaseName((String)file.getName());
        if (baseName.equalsIgnoreCase("default")) {
            return TemplateType.DEFAULT;
        }
        if (baseName.equals("landing_page")) {
            return TemplateType.LANDING_PAGE;
        }
        if (baseName.equals("preview")) {
            return TemplateType.PREVIEW;
        }
        String error = "Template file's type is not valid: \"" + file.getName() + "\".";
        throw new DocBuildException(error);
    }

    private static void validateInputParams(Object[] params) {
        Utilities.validateCtorObjectsAreNotNull(params, Template.class.getSimpleName());
    }

    public String getContents() {
        return this.contents;
    }

    public TemplateType getType() {
        return this.type;
    }
}

