/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.documentation.builder;

import com.mulesoft.documentation.builder.Section;
import com.mulesoft.documentation.builder.model.SectionVersion;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VersionSelector {
    Section section;
    List<SectionVersion> sectionVersions;

    public VersionSelector(Section section, List<SectionVersion> sectionVersions) {
        this.section = section;
        this.sectionVersions = sectionVersions;
    }

    public static VersionSelector fromSectionAndVersions(Section section, List<SectionVersion> sectionVersions) {
        return new VersionSelector(section, sectionVersions);
    }

    public String htmlForPage() {
        Map<String, String> versionLinkMapping = this.getVersionLinkMappingAndOrder();
        String latestVersion = this.getLatestVersionString();
        boolean latestAlreadySet = false;
        int count = 1;
        String[] orderOfVersions = new String[versionLinkMapping.size()];
        if (this.section.getBaseName().isEmpty()) {
            return "";
        }
        if (versionLinkMapping.size() > 0 && !this.section.getVersionPrettyName().equals("latest")) {
            for (Map.Entry<String, String> entry : versionLinkMapping.entrySet()) {
                if (entry.getValue().equals(this.section.getVersionPrettyName())) {
                    if (entry.getValue().equals(latestVersion)) {
                        orderOfVersions[0] = "<option value=\"" + entry.getKey() + "\">" + entry.getValue() + " (Latest)</option>";
                        latestAlreadySet = true;
                        continue;
                    }
                    orderOfVersions[0] = "<option value=\"" + entry.getKey() + "\">" + entry.getValue() + " (Active)</option>";
                    continue;
                }
                if (!latestAlreadySet && entry.getValue().equals(latestVersion)) {
                    orderOfVersions[count] = "<option value=\"" + entry.getKey() + "\">" + entry.getValue() + " (Latest)</option>";
                    ++count;
                    continue;
                }
                orderOfVersions[count] = "<option value=\"" + entry.getKey() + "\">" + entry.getValue() + "</option>";
                ++count;
            }
        } else {
            return "";
        }
        versionLinkMapping = null;
        return this.addVersionOrderToOutputString(orderOfVersions);
    }

    private String addVersionOrderToOutputString(String[] outputOrder) {
        String output = "<label for=\"version-selector\">" + this.section.getPrettyName() + " Version</label>";
        output = output + "<select onChange=\"window.location.href=this.value\" id=\"version-selector\">";
        for (String version : outputOrder = this.sortVersionOrder(outputOrder)) {
            output = output + version;
        }
        output = output + "</select>\n";
        return output;
    }

    private String[] sortVersionOrder(String[] original) {
        if (original.length > 2) {
            int i;
            String[] replacement = new String[original.length];
            String[] tempArr = new String[original.length - 1];
            String temp = original[0];
            for (i = 1; i < original.length; ++i) {
                tempArr[i - 1] = original[i];
            }
            Arrays.sort(tempArr, Collections.reverseOrder());
            for (i = 1; i <= tempArr.length; ++i) {
                replacement[i] = tempArr[i - 1];
            }
            replacement[0] = temp;
            return replacement;
        }
        return original;
    }

    private String getLatestVersionString() {
        for (SectionVersion version : this.sectionVersions) {
            if (!version.isLatestVersion()) continue;
            return version.getVersionName();
        }
        return "";
    }

    public Map<String, String> getVersionLinkMappingAndOrder() {
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (SectionVersion version : this.sectionVersions) {
            mapping.put(version.getVersionUrl(), version.getVersionName());
        }
        return mapping;
    }
}

