/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.documentation.builder;

import com.mulesoft.documentation.builder.AsciiDocPage;
import com.mulesoft.documentation.builder.Breadcrumb;
import com.mulesoft.documentation.builder.PageMetadata;
import com.mulesoft.documentation.builder.Section;
import com.mulesoft.documentation.builder.SectionNavigator;
import com.mulesoft.documentation.builder.SiteTableOfContents;
import com.mulesoft.documentation.builder.SiteTocHtml;
import com.mulesoft.documentation.builder.SwiftTypeMetadata;
import com.mulesoft.documentation.builder.Template;
import com.mulesoft.documentation.builder.TemplateType;
import com.mulesoft.documentation.builder.VersionSelector;
import com.mulesoft.documentation.builder.model.SectionVersion;
import com.mulesoft.documentation.builder.util.Utilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Page {
    private static Logger logger = LoggerFactory.getLogger(Page.class);
    private String content;
    private String baseName;

    public Page(String content, String baseName) {
        this.content = content;
        this.baseName = baseName;
    }

    public static List<Page> forSection(Section section, List<Section> allSections, List<Template> templates, SiteTableOfContents toc, String gitHubRepoUrl, String gitHubBranchName, List<SectionVersion> sectionVersions, String siteRootUrl) {
        ArrayList<Page> pages = new ArrayList<Page>();
        for (AsciiDocPage page : section.getPages()) {
            Page current = new Page(Page.getCompletePageContent(section, allSections, toc, page, templates, gitHubRepoUrl, gitHubBranchName, sectionVersions, siteRootUrl), page.getBaseName());
            pages.add(current);
        }
        return pages;
    }

    public static String getCompletePageContent(Section section, List<Section> sections, SiteTableOfContents toc, AsciiDocPage page, List<Template> templates, String gitHubRepoUrl, String gitHubBranchName, List<SectionVersion> sectionVersions, String siteRootUrl) {
        logger.info("Building page from template for \"" + Page.getPageTitle(page) + "\".");
        StringBuilder html = new StringBuilder(Page.getTemplateContents(page, templates));
        html = Utilities.replaceText(html, "{{ page.title }}", Page.getPageTitle(page));
        html = Utilities.replaceText(html, "{{ page.toc }}", Page.getPageToc(toc, sections, section, page));
        html = Utilities.replaceText(html, "{{ page.breadcrumb }}", Page.getBreadcrumbHtml(section, page));
        html = Utilities.replaceText(html, "{{ page.content }}", Page.getContentHtml(page));
        html = Utilities.replaceText(html, "{{ page.version }}", Page.getVersionHtml(sections, section, sectionVersions, page));
        html = Utilities.replaceText(html, "{{ page.version-notification }}", Page.getVersionNotificationHtml(sections, section, sectionVersions, page));
        html = Utilities.replaceText(html, "{{ page.sections }}", Page.getSectionNavigator(page));
        html = Utilities.replaceText(html, "{{ page.metadata }}", Page.getPageMetadata(page));
        html = Utilities.replaceText(html, "{{ page.swifttype-metadata }}", Page.getSwiftTypeMetadata(page));
        html = Utilities.replaceText(html, "{{ page.github-link }}", Page.getGitHubRepoUrl(section, page, gitHubRepoUrl, gitHubBranchName));
        html = Utilities.replaceText(html, "{{ page.canonical }}", Page.getCanonicalUrlText(siteRootUrl, section, page));
        return html.toString();
    }

    private static String getTemplateContents(AsciiDocPage page, List<Template> templates) {
        if (!page.containsAttribute("mule-template")) {
            for (Template template : templates) {
                if (!template.getType().equals((Object)TemplateType.DEFAULT)) continue;
                return template.getContents();
            }
        }
        return null;
    }

    private static String getGitHubRepoUrl(Section section, AsciiDocPage page, String gitHubRepoUrl, String gitHubBranchName) {
        if (section.getBaseName().equals("") && page.getBaseName().equals("index")) {
            return Utilities.getConcatPath(new String[]{gitHubRepoUrl, "blob", gitHubBranchName, section.getBaseName(), page.getBaseName() + ".adoc"});
        }
        return Utilities.getConcatPath(new String[]{gitHubRepoUrl, "blob", gitHubBranchName, section.getBaseName(), "v", section.getVersionPrettyName(), page.getBaseName() + ".adoc"});
    }

    private static String getPageTitle(AsciiDocPage page) {
        return page.getTitle();
    }

    private static String getPageToc(SiteTableOfContents toc, List<Section> sections, Section section, AsciiDocPage page) {
        SiteTocHtml tocHtml = SiteTocHtml.fromSiteTocAndSections(toc, sections);
        return tocHtml.getTocHtmlForSectionAndPage(section, page);
    }

    private static String getBreadcrumbHtml(Section section, AsciiDocPage page) {
        Breadcrumb breadcrumb = Breadcrumb.fromRootNode(section.getRootNode());
        return breadcrumb.getHtmlForActiveUrl(page.getBaseName(), "");
    }

    private static String getContentHtml(AsciiDocPage page) {
        Document doc = Jsoup.parse((String)page.getHtml(), (String)"UTF-8");
        return Utilities.getOnlyContentDivFromHtml(doc.html());
    }

    private static String getVersionHtml(List<Section> sections, Section section, List<SectionVersion> sectionVersions, AsciiDocPage page) {
        return new VersionSelector(sections, section, sectionVersions).htmlForPage(page);
    }

    private static String getPageMetadata(AsciiDocPage page) {
        return PageMetadata.fromAsciiDocPage(page);
    }

    private static String getSwiftTypeMetadata(AsciiDocPage page) {
        return SwiftTypeMetadata.fromAsciiDocPage(page);
    }

    private static String getVersionNotificationHtml(List<Section> sections, Section section, List<SectionVersion> sectionVersions, AsciiDocPage page) {
        for (SectionVersion version : sectionVersions) {
            Optional<Section> sectionForVersion;
            if (!version.isLatestVersion()) continue;
            if (section.getSectionVersion().equals(version)) break;
            String target = version.getVersionUrl();
            String relativePageUrl = page.getRelativeUrl();
            if (!relativePageUrl.isEmpty() && (sectionForVersion = sections.stream().filter(s -> s.getSectionVersion().equals(version)).findFirst()).isPresent() && sectionForVersion.get().containsPageMatching(page)) {
                target = target.concat("/").concat(relativePageUrl);
            }
            return "<div class=\"older-version-notification col-md-9\" data-swiftype-index='false'>You are viewing an older version of this section. Click <a href=\"" + target + "\">here</a> to navigate to the latest version.</div>";
        }
        return "";
    }

    private static String getCanonicalUrlText(String siteRootUrl, Section section, AsciiDocPage page) {
        if (!section.getVersionPrettyName().equals("latest")) {
            String relativeUrl = !page.getBaseName().equals("index") ? Utilities.getConcatPath(new String[]{section.getBaseName(), "v", section.getVersionPrettyName(), page.getBaseName()}) : Utilities.getConcatPath(new String[]{section.getBaseName(), "v", section.getVersionPrettyName()});
            return "<link rel=\"canonical\" href=\"" + Utilities.getConcatPath(new String[]{siteRootUrl, relativeUrl}) + "\" />";
        }
        String relativeUrl = !page.getBaseName().equals("index") ? Utilities.getConcatPath(new String[]{section.getBaseName(), page.getBaseName()}) : section.getBaseName();
        return "<link rel=\"canonical\" href=\"" + Utilities.getConcatPath(new String[]{siteRootUrl, relativeUrl}) + "\" />";
    }

    private static String getSectionNavigator(AsciiDocPage page) {
        return SectionNavigator.getHtmlForPage(page);
    }

    public String getContent() {
        return this.content;
    }

    public String getBaseName() {
        return this.baseName;
    }
}

