/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.documentation.builder;

import com.mulesoft.documentation.builder.AsciiDocPage;
import com.mulesoft.documentation.builder.SwiftypeMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageMetadata {
    private static Logger logger = LoggerFactory.getLogger(PageMetadata.class);

    public static String fromAsciiDocPage(AsciiDocPage page) {
        return PageMetadata.getMetadataEntries(page);
    }

    public static String getMetadataEntries(AsciiDocPage page) {
        logger.debug("Creating metadata for page \"" + page.getTitle() + "\"...");
        return PageMetadata.getBodyMetadata(page);
    }

    public static String getBodyMetadata(AsciiDocPage page) {
        String bodyText = SwiftypeMetadata.getDescription(page);
        return bodyText.isEmpty() ? "" : "<meta name=\"description\" content=\"" + bodyText + "\" />";
    }
}

