/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.documentation.builder;

import com.mulesoft.documentation.builder.AsciiDocPage;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class SectionNavigator {
    public static String getHtmlForPage(AsciiDocPage page) {
        String html = page.getHtml();
        LinkedHashMap<String, String> sectionTitlesAndUrls = new LinkedHashMap<String, String>();
        Document doc = Jsoup.parse((String)html, (String)"UTF-8");
        Elements elements = doc.select("h2");
        if (elements.size() == 0) {
            elements = doc.select("h3");
            if (elements.size() == 0) {
                elements = doc.select("h4");
                SectionNavigator.addHeadingToCollection((List<Element>)elements, sectionTitlesAndUrls);
                return SectionNavigator.getHtml(sectionTitlesAndUrls);
            }
            SectionNavigator.addHeadingToCollection((List<Element>)elements, sectionTitlesAndUrls);
            return SectionNavigator.getHtml(sectionTitlesAndUrls);
        }
        SectionNavigator.addHeadingToCollection((List<Element>)elements, sectionTitlesAndUrls);
        return SectionNavigator.getHtml(sectionTitlesAndUrls);
    }

    public static String getHtml(Map<String, String> sectionTitlesAndUrls) {
        String output = "";
        if (sectionTitlesAndUrls.entrySet().size() > 0) {
            output = "<!-- scroll-menu --><div class=\"col-md-2 scroll-menu-container\" data-swiftype-index='false'><div class=\"scroll-menu\">\n                <h4>In this topic:</h4>\n                <ul>";
            for (Map.Entry<String, String> entry : sectionTitlesAndUrls.entrySet()) {
                output = output + "<li><a class=\"scroll-menu-link\" href=\"" + entry.getKey() + "\">" + entry.getValue() + "</a></li>";
            }
            output = output + "</ul></div></div><!-- /scroll-menu -->";
        }
        return output;
    }

    public static void addHeadingToCollection(List<Element> elements, Map<String, String> collection) {
        for (Element element : elements) {
            String title = element.text();
            String url = element.select("a").get(0).attr("href");
            if (url == null) continue;
            collection.put(url, title);
        }
    }
}

