/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.documentation.builder;

import com.mulesoft.documentation.builder.AsciiDocProcessor;
import com.mulesoft.documentation.builder.util.Utilities;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.asciidoctor.ast.Block;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.extension.BlockProcessor;
import org.asciidoctor.extension.ContentModel;
import org.asciidoctor.extension.Contexts;
import org.asciidoctor.extension.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contexts(value={":listing"})
@ContentModel(value=":compound")
public class TabsProcessor
extends BlockProcessor {
    private static Logger logger = LoggerFactory.getLogger(TabsProcessor.class);
    private AsciiDocProcessor processor = AsciiDocProcessor.getProcessorInstance();

    public Object process(StructuralNode parent, Reader reader, Map<String, Object> attributes) {
        Document doc = parent.getDocument();
        HashSet<String> tabTitles = new HashSet<String>();
        long tabsetIndex = (Long)doc.getAttr((Object)"tabset-counter", (Object)0L) + 1L;
        doc.setAttr((Object)"tabset-counter", (Object)tabsetIndex, true);
        Block tabset = this.createBlock(parent, "open", Collections.emptyList());
        tabset.setAttr((Object)"tabset-index", (Object)tabsetIndex, true);
        this.parseContent((StructuralNode)tabset, reader.readLines());
        List tabs = tabset.getBlocks();
        int i = 0;
        for (Object tab : tabs) {
            String tabTitle = (String)tab.getAttr((Object)"title");
            if (!tabTitles.add(tabTitle)) {
                logger.warn("Duplicate tab title detected in " + doc.getAttr((Object)"docfile", (Object)"<stdin>") + ".");
            }
            String tabId = "tab-" + tabsetIndex + "_" + (i + 1);
            String tabContent = Utilities.getOnlyContentDivFromHtml(this.processor.convertAsciiDocString((String)tab.getContent()));
            String tabPanel = "<div class=\"tab-pane " + (i == 0 ? "in active " : "") + "fade no-padding\" id=\"" + tabId + "\">" + tabContent + "</div>";
            tab = this.createBlock(parent, "pass", tabPanel);
            tab.setId(tabId);
            tab.setTitle(tabTitle);
            tabs.set(i, tab);
            ++i;
        }
        String tabsetPanelOpen = "<div class=\"panel panel-default no-padding\">\n    <div class=\"panel-heading no-padding\">\n        <!-- Nav tabs -->\n        <ul class=\"nav nav-tabs\" role=\"tablist\">\n";
        i = 0;
        for (StructuralNode tab : tabs) {
            tabsetPanelOpen = tabsetPanelOpen + "<li" + (i == 0 ? " class=\"active\"" : "") + ">" + "<a href=\"#" + tab.getId() + "\" role=\"tab\" data-toggle=\"tab\">" + tab.getTitle() + "</a>" + "</li>\n";
            ++i;
        }
        tabsetPanelOpen = tabsetPanelOpen + "</ul>\n</div>\n<div class=\"panel-body tab-content no-padding\">";
        String tabsetPanelClose = "</div></div>";
        return this.createBlock(parent, "pass", tabsetPanelOpen + (String)tabset.getContent() + tabsetPanelClose);
    }
}

