/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.documentation.builder;

import com.mulesoft.documentation.builder.AsciiDocProcessor;
import com.mulesoft.documentation.builder.util.Utilities;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.ast.DocumentHeader;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsciiDocPage {
    private static Logger logger = LoggerFactory.getLogger(AsciiDocPage.class);
    private static Asciidoctor processor;
    private String baseName;
    private String filePath;
    private String asciiDoc;
    private String html;
    private String title;

    public AsciiDocPage(String filename, String baseName, String asciiDoc, String html, String title) {
        this.validateInputParams(new String[]{filename, asciiDoc, html});
        this.filePath = filename;
        this.baseName = baseName;
        this.asciiDoc = asciiDoc;
        this.html = html;
        this.title = title;
    }

    public static List<AsciiDocPage> fromFiles(List<File> asciiDocFiles) {
        ArrayList<AsciiDocPage> docPages = new ArrayList<AsciiDocPage>();
        asciiDocFiles.stream().forEach(file -> {
            logger.debug("Creating AsciiDocPage from file: \"" + file.getPath() + "\".");
            docPages.add(AsciiDocPage.getPageFromFile(file));
        });
        return docPages;
    }

    public static AsciiDocPage fromFile(File asciiDocFile) {
        processor = Asciidoctor.Factory.create();
        return AsciiDocPage.getPageFromFile(asciiDocFile);
    }

    private static AsciiDocPage getPageFromFile(File asciiDocFile) {
        Utilities.validateAsciiDocFile(asciiDocFile);
        String html = AsciiDocProcessor.getProcessorInstance().convertFile(asciiDocFile);
        AsciiDocPage page = new AsciiDocPage(asciiDocFile.getPath(), FilenameUtils.getBaseName((String)asciiDocFile.getName()), Utilities.getFileContentsFromFile(asciiDocFile), html, AsciiDocPage.getPageTitle(html));
        return page;
    }

    public Map<String, Object> getAttributes() {
        Asciidoctor processor = this.getProcessor();
        DocumentHeader header = processor.readDocumentHeader(this.getAsciiDoc());
        return header.getAttributes();
    }

    public boolean containsAttribute(String attributeName) {
        Map<String, Object> attributes = this.getAttributes();
        return attributes.containsKey(attributeName);
    }

    public String getAttributeValue(String attributeName) {
        if (!this.containsAttribute(attributeName)) {
            return null;
        }
        Map<String, Object> attributes = this.getAttributes();
        return attributes.get(attributeName).toString();
    }

    private static String getPageTitle(String html) {
        return Jsoup.parse((String)html).title().trim();
    }

    private void validateInputParams(String[] params) {
        Utilities.validateCtorStringInputParam(params, AsciiDocPage.class.getSimpleName());
    }

    public Asciidoctor getProcessor() {
        return processor;
    }

    public static void shutdownProcessor() {
        processor.shutdown();
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getAsciiDoc() {
        return this.asciiDoc;
    }

    public String getHtml() {
        return this.html;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getTitle() {
        return this.title;
    }

    public String getRelativeUrl() {
        return this.baseName.equals("index") ? "" : this.baseName;
    }

    public boolean isIndex() {
        return this.baseName.equals("index");
    }
}

