/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.documentation.builder;

import com.mulesoft.documentation.builder.AsciiDocPage;
import com.mulesoft.documentation.builder.DocBuildException;
import com.mulesoft.documentation.builder.model.TocNode;
import com.mulesoft.documentation.builder.util.Utilities;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootNodeFromHtmlToc {
    private static Logger logger = LoggerFactory.getLogger(RootNodeFromHtmlToc.class);
    private TocNode rootNode;

    public RootNodeFromHtmlToc(TocNode rootNode) {
        this.validateInputParams(new Object[]{rootNode});
        this.rootNode = rootNode;
    }

    public static RootNodeFromHtmlToc fromTocAsciiDocPage(AsciiDocPage asciiDocPage) {
        RootNodeFromHtmlToc.validateThatAsciiDocPageIsToc(asciiDocPage);
        logger.info("Creating root node for TOC page \"" + asciiDocPage.getFilePath() + "\".");
        String contentHtml = Utilities.getOnlyContentDivFromHtml(asciiDocPage.getHtml());
        Document htmlToc = Jsoup.parse((String)contentHtml, (String)"UTF-8");
        TocNode rootNode = RootNodeFromHtmlToc.getRootNodeFromRawTocHtml(htmlToc);
        return new RootNodeFromHtmlToc(rootNode);
    }

    public static TocNode getRootNodeFromRawTocHtml(Document doc) {
        Element firstElement = doc.select("ul").first();
        Element firstItem = firstElement.select("li").first();
        String parentLink = RootNodeFromHtmlToc.cleanupLink(firstItem.select("a").first().attr("href"));
        String parentTitle = firstItem.select("a").first().text();
        TocNode firstNode = new TocNode(parentLink, parentTitle, null);
        Elements firstChildren = firstItem.children().select("ul");
        RootNodeFromHtmlToc.validateOnlyOneRootNode(firstChildren);
        RootNodeFromHtmlToc.processToc(firstChildren.first(), firstNode);
        firstItem.remove();
        RootNodeFromHtmlToc.processToc(firstElement, firstNode);
        return firstNode;
    }

    private static void processToc(Element listElement, TocNode parentNode) {
        Element firstItem = listElement.select("li").first();
        if (firstItem == null) {
            return;
        }
        String parentLink = RootNodeFromHtmlToc.cleanupLink(firstItem.select("a").first().attr("href"));
        String parentTitle = firstItem.select("a").first().text();
        TocNode node = new TocNode(parentLink, parentTitle, parentNode);
        parentNode.addChild(node);
        Elements firstChildren = firstItem.children().select("ul");
        Elements listItems = firstChildren.select("li");
        if (firstChildren.size() > 1) {
            RootNodeFromHtmlToc.processToc(firstChildren.first(), node);
            firstItem.remove();
            RootNodeFromHtmlToc.processToc(listElement, parentNode);
        } else if (firstChildren.size() == 0) {
            firstItem.remove();
            RootNodeFromHtmlToc.processToc(listElement, parentNode);
        } else {
            RootNodeFromHtmlToc.processSection(listItems, node);
            firstItem.remove();
            RootNodeFromHtmlToc.processToc(listElement, parentNode);
        }
    }

    private static void processSection(Elements siblings, TocNode parentNode) {
        for (Element sibling : siblings) {
            String siblingLink = RootNodeFromHtmlToc.cleanupLink(sibling.select("a").first().attr("href"));
            String siblingTitle = sibling.select("a").first().text();
            TocNode siblingNode = new TocNode(siblingLink, siblingTitle, parentNode);
            parentNode.addChild(siblingNode);
        }
    }

    private static void validateOnlyOneRootNode(Elements elements) {
        if (elements.size() == 0) {
            String error = "TOC file has more than one root node and appears to be malformed.";
            logger.error(error);
            throw new DocBuildException(error);
        }
    }

    public static String cleanupLink(String link) {
        int lastSlashOffset = link.lastIndexOf("/");
        if (lastSlashOffset >= 0) {
            link = link.substring(lastSlashOffset + 1);
        }
        link = RootNodeFromHtmlToc.removeHtmlExtension(link);
        link = RootNodeFromHtmlToc.removeIndexFromLink(link);
        return link;
    }

    private static String removeHtmlExtension(String link) {
        return link.replaceFirst("\\.html$", "");
    }

    private static String removeIndexFromLink(String link) {
        return link.equals("index") ? "" : link;
    }

    private void validateInputParams(Object[] params) {
        Utilities.validateCtorObjectsAreNotNull(params, RootNodeFromHtmlToc.class.getSimpleName());
    }

    private static void validateThatAsciiDocPageIsToc(AsciiDocPage page) {
        if (!page.getFilePath().endsWith("_toc.adoc")) {
            String error = "AsciiDoc page appears to be invalid for processing table of contents: \"" + page.getFilePath() + "\".";
            logger.error(error);
            throw new DocBuildException(error);
        }
    }

    public TocNode getRootNode() {
        return this.rootNode;
    }
}

