/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.documentation.builder;

import com.mulesoft.documentation.builder.AsciiDocPage;
import com.mulesoft.documentation.builder.DocBuildException;
import com.mulesoft.documentation.builder.SectionTableOfContents;
import com.mulesoft.documentation.builder.model.SectionVersion;
import com.mulesoft.documentation.builder.model.TocNode;
import com.mulesoft.documentation.builder.util.Utilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Section {
    private static Logger logger = LoggerFactory.getLogger(Section.class);
    private List<AsciiDocPage> pages;
    private TocNode rootNode;
    private String filepath;
    private String url;
    private String prettyName;
    private String versionPrettyName;
    private String baseName;
    private SectionVersion sectionVersion;

    public Section(List<AsciiDocPage> pages, TocNode rootNode, String filepath, String url, String prettyName, String versionPrettyName, String baseName, SectionVersion sectionVersion) {
        this.pages = pages;
        this.rootNode = rootNode;
        this.filepath = filepath;
        this.url = url;
        this.prettyName = prettyName;
        this.baseName = baseName;
        this.versionPrettyName = versionPrettyName;
        this.sectionVersion = sectionVersion;
    }

    public List<AsciiDocPage> getPages() {
        return this.pages;
    }

    public TocNode getRootNode() {
        return this.rootNode;
    }

    public String getFilepath() {
        return this.filepath;
    }

    public String getUrl() {
        return this.url;
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public String getVersionPrettyName() {
        return this.versionPrettyName;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public SectionVersion getSectionVersion() {
        return this.sectionVersion;
    }

    public boolean isSiteRoot() {
        return this.baseName.isEmpty();
    }

    public boolean isVersionless() {
        return this.versionPrettyName.equals("latest");
    }

    public boolean containsPageMatching(AsciiDocPage page) {
        if (this.getPages().contains(page)) {
            return true;
        }
        String baseName = page.getBaseName();
        for (AsciiDocPage candidate : this.getPages()) {
            if (!candidate.getBaseName().equals(baseName)) continue;
            return true;
        }
        return false;
    }

    public static Section fromDirectoryAndSectionVersion(File directory, SectionVersion sectionVersion) {
        Section.validateDirectory(directory);
        return Section.getSectionFromDirectory(directory, sectionVersion, "");
    }

    private static Section getSectionFromDirectory(File directory, SectionVersion sectionVersion, String url) {
        File[] filesInDirectory = directory.listFiles();
        if (filesInDirectory != null) {
            logger.info(String.format("Processing section located at [%s].", directory.getAbsolutePath()));
            List<File> validFiles = Section.getValidAsciiDocFilesInSection(new ArrayList<File>(Arrays.asList(filesInDirectory)));
            List<AsciiDocPage> pages = AsciiDocPage.fromFiles(validFiles);
            File tocFile = new File(Utilities.getConcatPath(new String[]{directory.getPath(), "_toc.adoc"}));
            TocNode rootNode = SectionTableOfContents.fromAsciiDocFile(tocFile).getRootTocNode();
            url = Utilities.getConcatPath(new String[]{url, Utilities.removeLeadingSlashes(sectionVersion.getVersionUrl())});
            return new Section(pages, rootNode, directory.getPath(), url, sectionVersion.getSectionPrettyName(), sectionVersion.getVersionName(), sectionVersion.getSectionBaseName(), sectionVersion);
        }
        throw new DocBuildException("Section directory was empty: " + directory);
    }

    private static List<File> getValidAsciiDocFilesInSection(List<File> files) {
        ArrayList<File> validFiles = new ArrayList<File>();
        for (File file : files) {
            if (file.isDirectory() || !Utilities.fileEndsWithValidAsciidocExtension(file.getName()) || file.getName().equals("_toc.adoc")) continue;
            validFiles.add(file);
        }
        return validFiles;
    }

    public static String getVersionUrl(String directoryPath, String sectionName) {
        List<String> pathEntries = Section.getDirectoriesOrFilesBetweenSeparators(directoryPath);
        String buffer = "";
        for (String entry : pathEntries) {
            String temp = new StringBuilder(entry).reverse().toString();
            if (!temp.equals(sectionName)) {
                buffer = buffer + entry + File.separator;
                continue;
            }
            return new StringBuilder(buffer + entry).reverse().toString();
        }
        return sectionName;
    }

    private static List<String> getDirectoriesOrFilesBetweenSeparators(String directoryPath) {
        ArrayList<String> fileOrDirectories = new ArrayList<String>();
        String buffer = "";
        for (int i = directoryPath.length() - 1; i > 0; --i) {
            char current = directoryPath.charAt(i);
            if (current != File.separatorChar) {
                buffer = buffer + current;
                continue;
            }
            if (buffer.isEmpty()) continue;
            fileOrDirectories.add(buffer);
            buffer = "";
        }
        return fileOrDirectories;
    }

    private static void validateDirectory(File directory) {
        Utilities.validateIsDirectory(directory);
        Utilities.validateDirectoryContainsAsciiDocFile(directory);
        Utilities.validateDirectoryContainsTocFile(directory);
    }
}

