/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.documentation.builder;

import com.mulesoft.documentation.builder.AsciiDocProcessor;
import com.mulesoft.documentation.builder.util.Utilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.asciidoctor.ast.AbstractBlock;
import org.asciidoctor.ast.Block;
import org.asciidoctor.extension.BlockProcessor;
import org.asciidoctor.extension.ContentModel;
import org.asciidoctor.extension.Contexts;
import org.asciidoctor.extension.Reader;

@Contexts(value={":listing"})
@ContentModel(value=":compound")
public class TabProcessor
extends BlockProcessor {
    private AsciiDocProcessor processor = AsciiDocProcessor.getProcessorInstance();

    @Override
    public Object process(AbstractBlock parent, Reader reader, Map<String, Object> attributes) {
        HashMap<String, Object> inherited2 = new HashMap<String, Object>();
        int tabHash = parent.toString().hashCode();
        Block container = this.createBlock(parent, "open", (String)null, inherited2, new HashMap<Object, Object>());
        LinkedHashMap<String, String> titleAndId = new LinkedHashMap<String, String>();
        int count2 = 0;
        this.parseContent(container, reader.readLines());
        for (int i2 = 0; i2 < container.getBlocks().size(); ++i2) {
            AbstractBlock child = container.getBlocks().get(i2);
            String tabTitle = child.getTitle();
            String uniqueId = Utilities.cleanPageFileNames(tabTitle) + "-" + tabHash;
            titleAndId.put(tabTitle, uniqueId);
            String singleTabHtmlOpen = count2 == 0 ? "<div class=\"tab-pane in active fade no-padding\" id=\"" + uniqueId + "\">" : "<div class=\"tab-pane fade no-padding\" id=\"" + uniqueId + "\">";
            String converted = this.processor.convertAsciiDocString(child.content().toString());
            converted = Utilities.getOnlyContentDivFromHtml(converted);
            converted = singleTabHtmlOpen + converted + "</div>";
            Block block = this.createBlock(parent, "pass", converted, inherited2, new HashMap<Object, Object>());
            ++count2;
            container.getBlocks().set(i2, block);
        }
        String tabsOpen = "<div class=\"panel panel-default no-padding\">\n    <div class=\"panel-heading no-padding\">\n        <!-- Nav tabs -->\n        <ul class=\"nav nav-tabs\" role=\"tablist\">\n";
        ArrayList randAccess = new ArrayList(titleAndId.entrySet());
        for (int i3 = 0; i3 < titleAndId.size(); ++i3) {
            if (i3 == 0) {
                tabsOpen = tabsOpen + "<li class=\"active\">";
                tabsOpen = tabsOpen + "<a href=\"#" + (String)((Map.Entry)randAccess.get(i3)).getValue() + "\" role=\"tab\" data-toggle=\"tab\">" + (String)((Map.Entry)randAccess.get(i3)).getKey() + "</a></li>\n";
                continue;
            }
            tabsOpen = tabsOpen + "<li><a href=\"#" + (String)((Map.Entry)randAccess.get(i3)).getValue() + "\" role=\"tab\" data-toggle=\"tab\">" + (String)((Map.Entry)randAccess.get(i3)).getKey() + "</a></li>\n";
        }
        tabsOpen = tabsOpen + "</ul>\n</div>\n<div class=\"panel-body tab-content no-padding\">";
        String tabsClose = "</div></div>";
        titleAndId = null;
        randAccess = null;
        String containerContents = tabsOpen + container.getContent().toString() + tabsClose;
        return this.createBlock(parent, "pass", containerContents, inherited2, new HashMap<Object, Object>());
    }
}

