/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.documentation.builder.previewer;

import com.mulesoft.documentation.builder.Template;
import com.mulesoft.documentation.builder.TemplateType;
import com.mulesoft.documentation.builder.previewer.AsciiDocPage;
import com.mulesoft.documentation.builder.previewer.SectionNavigator;
import com.mulesoft.documentation.builder.previewer.Utilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class SinglePage {
    private static Logger logger = Logger.getLogger(SinglePage.class);

    public static void fromAsciiDocFile(String asciiDocFilePath, String outputDirPath) {
        boolean success2;
        System.out.println("Converting file to html: " + asciiDocFilePath);
        AsciiDocPage page = AsciiDocPage.fromFile(new File(asciiDocFilePath));
        String result2 = SinglePage.buildPage(page);
        File outputDir = new File(outputDirPath);
        if (!outputDir.exists() && !(success2 = outputDir.mkdir())) {
            System.out.println("\nError creating directory for output file: " + outputDirPath);
            System.exit(-1);
        }
        String outputFilePath = Utilities.getConcatPath(new String[]{outputDirPath, page.getBaseName() + ".html"});
        Utilities.writeFileToDirectory(outputFilePath, result2);
        System.out.println("Saved output file to: " + Utilities.getConcatPath(new String[]{outputDirPath, page.getBaseName() + ".html"}));
    }

    private static String buildPage(AsciiDocPage page) {
        Template template = SinglePage.getTemplate();
        StringBuilder html = new StringBuilder(SinglePage.getTemplateContents(page, template));
        html = Utilities.replaceText(html, "{{ page.title }}", SinglePage.getPageTitle(page));
        html = Utilities.replaceText(html, "{{ page.content }}", SinglePage.getContentHtml(page));
        html = Utilities.replaceText(html, "{{ page.sections }}", SinglePage.getSectionNavigator(page));
        return html.toString();
    }

    private static String getPageTitle(AsciiDocPage page) {
        return page.getTitle();
    }

    private static String getTemplateContents(AsciiDocPage page, Template template) {
        return template.getContents();
    }

    private static String getSectionNavigator(AsciiDocPage page) {
        return SectionNavigator.getHtmlForPage(page);
    }

    private static String getContentHtml(AsciiDocPage page) {
        Document doc = Jsoup.parse(page.getHtml(), "UTF-8");
        return Utilities.getOnlyContentDivFromHtml(doc.html());
    }

    private static Template getTemplate() {
        Template template = null;
        try (InputStream contentStream = ClassLoader.class.getResourceAsStream("/preview.template");){
            String content = IOUtils.toString(contentStream);
            template = Template.fromString(TemplateType.PREVIEW, content);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading contents of template.");
        }
        return template;
    }

    private static String getResourcesPath() {
        URL pathToResource = SinglePage.class.getClassLoader().getResource("");
        String resourcesPath = "";
        if (pathToResource != null && !StringUtils.isEmpty(resourcesPath = pathToResource.getFile())) {
            return resourcesPath;
        }
        throw new RuntimeException("Resources path was null.");
    }
}

