/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.documentation.builder.previewer;

import com.mulesoft.documentation.builder.DocBuildException;
import com.mulesoft.documentation.builder.model.TocNode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class Utilities {
    static Logger logger = Logger.getLogger(Utilities.class);

    public static String getFileContentsFromFile(File file2) {
        String contents = "";
        try {
            FileReader reader = new FileReader(file2);
            contents = IOUtils.toString(reader);
        }
        catch (FileNotFoundException ffe) {
            String error2 = "The file \"" + file2.getName() + "\" was not found.";
            logger.fatal(error2, ffe);
            throw new DocBuildException(error2);
        }
        catch (IOException ioe) {
            String error3 = "Cannot get file contents for \"" + file2.getName() + "\".";
            logger.fatal(error3, ioe);
            throw new DocBuildException(error3);
        }
        return contents;
    }

    public static List<String> getFileContentsFromFiles(List<File> files) {
        ArrayList<String> fileContents = new ArrayList<String>();
        for (File file2 : files) {
            try {
                FileReader reader = new FileReader(file2);
                fileContents.add(IOUtils.toString(reader));
            }
            catch (FileNotFoundException ffe) {
                String error2 = "The file \"" + file2.getName() + "\" was not found.";
                logger.fatal(error2, ffe);
                throw new DocBuildException(error2);
            }
            catch (IOException ioe) {
                String error3 = "Cannot get file contents for \"" + file2.getName() + "\".";
                logger.fatal(error3, ioe);
                throw new DocBuildException(error3);
            }
        }
        return fileContents;
    }

    public static boolean fileEndsWithValidAsciidocExtension(String fileName) {
        String extension = FilenameUtils.getExtension(fileName);
        return extension.equalsIgnoreCase("ad") || extension.equalsIgnoreCase("asciidoc") || extension.equalsIgnoreCase("adoc");
    }

    public static void validateAsciiDocFile(File asciiDocFile) {
        if (!asciiDocFile.exists()) {
            String error2 = "AsciiDoc file does not exist: \"" + asciiDocFile.getPath() + "\".";
            logger.fatal(error2);
            throw new DocBuildException(error2);
        }
        if (!Utilities.fileEndsWithValidAsciidocExtension(asciiDocFile.getName())) {
            String error3 = "Presumed AsciiDoc file does not have valid extension: \"" + asciiDocFile.getName() + "\".";
            logger.fatal(error3);
            throw new DocBuildException(error3);
        }
    }

    public static String getConcatPath(String[] filesOrDirectoriesToAppend) {
        String temp = filesOrDirectoriesToAppend[0];
        for (int i2 = 1; i2 < filesOrDirectoriesToAppend.length; ++i2) {
            temp = !temp.isEmpty() && !temp.endsWith("/") ? temp.concat("/").concat(filesOrDirectoriesToAppend[i2]) : temp.concat(filesOrDirectoriesToAppend[i2]);
        }
        return temp;
    }

    public static String removeLeadingSlashes(String s2) {
        if (s2.startsWith("/") && s2.length() > 1) {
            s2 = s2.substring(1);
        }
        return s2;
    }

    public static StringBuilder replaceText(StringBuilder original, String toReplace, String replacement2) {
        String modified = original.toString().replace(toReplace, replacement2);
        return new StringBuilder(modified);
    }

    public static String getOnlyContentDivFromHtml(String html) {
        Document doc = Jsoup.parse(html, "UTF-8");
        return doc.getElementById("content").html();
    }

    public static void validateCtorStringInputParam(String[] params2, String className) {
        for (String param : params2) {
            if (!StringUtils.isBlank(param)) continue;
            String error2 = "Constructor input parameter for " + className + " cannot be null, empty, or whitespace.";
            logger.fatal(error2);
            throw new DocBuildException(error2);
        }
    }

    public static String cleanPageFileNames(String originalFilename) {
        if (originalFilename != null) {
            String result2 = originalFilename;
            try {
                result2 = URLDecoder.decode(originalFilename, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                System.out.println("Couldn't decode filename: " + originalFilename + "\n" + e);
            }
            result2 = result2.toLowerCase();
            result2 = StringUtils.replacePattern(result2, "(_[0-9].)", "-");
            result2 = StringUtils.replacePattern(result2, "(\\([0-9]\\))", "-");
            result2 = StringUtils.replacePattern(result2, "([^\\w\\/\\.\\-])", "-");
            result2 = StringUtils.replacePattern(result2, "(-)(-*)", "-");
            if (result2.endsWith("-")) {
                result2 = result2.substring(0, result2.length() - 1);
            }
            return result2;
        }
        throw new NullPointerException("String references are null.");
    }

    public static void validateCtorObjectsAreNotNull(Object[] params2, String className) {
        for (Object obj : params2) {
            if (obj == null) {
                String error2 = "Constructor input parameter for " + className + " cannot be null.";
                logger.fatal(error2);
                throw new DocBuildException(error2);
            }
            if (!obj.getClass().getSimpleName().equals("String")) continue;
            Utilities.validateCtorStringInputParam(new String[]{(String)obj}, className);
        }
    }

    public static String getRandomAlphaNumericString(int length2) {
        StringBuffer buffer = new StringBuffer();
        while (buffer.length() < length2) {
            buffer.append(Utilities.uuidString());
        }
        return buffer.substring(0, length2);
    }

    private static String uuidString() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static boolean isActiveUrlInSection(TocNode parentNode, String activeUrl, boolean isInSection) {
        if (parentNode.getParent() == null && parentNode.getUrl().equals(activeUrl)) {
            return true;
        }
        if (isInSection) {
            return true;
        }
        if (activeUrl.isEmpty()) {
            return false;
        }
        for (TocNode node : parentNode.getChildren()) {
            if (node.getUrl().equalsIgnoreCase(activeUrl)) {
                isInSection = true;
                continue;
            }
            if (node.getChildren().size() <= 0) continue;
            isInSection = Utilities.isActiveUrlInSection(node, activeUrl, isInSection);
        }
        return isInSection;
    }

    public static void validateIfActiveUrlIsInSection(TocNode root, String activeUrl) {
        if (root.getUrl().equals(activeUrl)) {
            return;
        }
        if (!Utilities.isActiveUrlInSection(root, activeUrl, false)) {
            String error2 = "Active URL does not exist in nodes for TOC: \"" + activeUrl + "\".";
            logger.fatal(error2);
            throw new DocBuildException(error2);
        }
    }

    public static void validateFileExists(File file2) {
        if (!file2.exists()) {
            String error2 = "File or directory does not exist: \"" + file2.getPath() + "\".";
            logger.fatal(error2);
            throw new DocBuildException(error2);
        }
    }

    public static void validateIsDirectory(File directory) {
        Utilities.validateFileExists(directory);
        if (!directory.isDirectory()) {
            String error2 = "File is not a directory as expected: \"" + directory.getPath() + "\".";
            logger.fatal(error2);
            throw new DocBuildException(error2);
        }
    }

    public static boolean directoryContainsAsciiDocFile(File directory) {
        boolean isValid = false;
        for (File file2 : directory.listFiles()) {
            if (!Utilities.fileEndsWithValidAsciidocExtension(file2.getName())) continue;
            isValid = true;
        }
        return isValid;
    }

    public static void validateDirectoryContainsAsciiDocFile(File directory) {
        if (!Utilities.directoryContainsAsciiDocFile(directory)) {
            String error2 = "Directory does not contain valid AsciiDoc file(s) as expected: \"" + directory.getPath() + "\".";
            logger.fatal(error2);
            throw new DocBuildException(error2);
        }
    }

    public static boolean directoryContainsTocFile(File directory) {
        boolean isValid = false;
        for (File file2 : directory.listFiles()) {
            if (!file2.getName().equals("_toc.adoc")) continue;
            isValid = true;
        }
        return isValid;
    }

    public static void validateDirectoryContainsTocFile(File directory) {
        if (!Utilities.directoryContainsTocFile(directory)) {
            String error2 = "Directory does not contain a TOC file: \"" + directory.getPath() + "\".";
            logger.fatal(error2);
            throw new DocBuildException(error2);
        }
    }

    public static void validatePrettyNameExists(File directory) {
        boolean exists = false;
        for (File file2 : directory.listFiles()) {
            if (!FilenameUtils.getExtension(file2.getName()).equals("version")) continue;
            exists = true;
        }
        if (!exists) {
            String error2 = "Directory does not contain version file: \"" + directory.getPath() + "\".";
            logger.fatal(error2);
            throw new DocBuildException(error2);
        }
    }

    public static boolean directoryContainsVersions(File directory) {
        File versionDir = new File(com.mulesoft.documentation.builder.util.Utilities.getConcatPath(new String[]{directory.getPath(), "v"}));
        if (!versionDir.exists()) {
            return false;
        }
        boolean containsDir = false;
        ArrayList<File> versionDirectories = new ArrayList<File>();
        for (File file2 : versionDir.listFiles()) {
            if (!file2.isDirectory()) continue;
            versionDirectories.add(file2);
            containsDir = true;
        }
        if (containsDir) {
            for (File file3 : versionDirectories) {
                if (Utilities.directoryContainsAsciiDocFile(file3) && Utilities.directoryContainsTocFile(file3)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static void validateMasterDirectory(File masterDirectory) {
        com.mulesoft.documentation.builder.util.Utilities.validateIsDirectory(masterDirectory);
        if (masterDirectory.isDirectory() && masterDirectory.exists()) {
            if (masterDirectory.listFiles().length > 0) {
                boolean containsDirectory = false;
                for (File file2 : masterDirectory.listFiles()) {
                    if (!file2.isDirectory()) continue;
                    containsDirectory = true;
                }
                if (!containsDirectory) {
                    String error2 = "Master directory does not contain valid section directories: \"" + masterDirectory.getPath() + "\".";
                    logger.fatal(error2);
                    throw new DocBuildException(error2);
                }
            } else {
                String error3 = "Master directory does not contain files or directories: \"" + masterDirectory.getPath() + "\".";
                logger.fatal(error3);
                throw new DocBuildException(error3);
            }
        }
    }

    public static void validateTemplateFile(File templateFile) {
        Utilities.validateFileExists(templateFile);
        if (!FilenameUtils.getExtension(templateFile.getName()).equals("template")) {
            String error2 = "Template file does not have valid '.template' extension: \"" + templateFile.getPath() + "\".";
            logger.fatal(error2);
            throw new DocBuildException(error2);
        }
    }

    public static boolean makeTargetDirectory(String directoryPath) {
        boolean result2 = false;
        try {
            File output = new File(directoryPath);
            result2 = output.mkdirs();
        }
        catch (SecurityException se) {
            String error2 = "Do not have permission to create directory \"" + directoryPath + "\"";
            logger.fatal(error2, se);
            throw new DocBuildException(error2);
        }
        return result2;
    }

    public static boolean deleteTargetDirectory(String directoryName) {
        boolean result2 = false;
        try {
            File output = new File(directoryName);
            result2 = output.delete();
        }
        catch (SecurityException se) {
            String error2 = "Do not have permission to delete directory \"" + directoryName + "\"";
            logger.fatal(error2, se);
            throw new DocBuildException(error2);
        }
        return result2;
    }

    public static void writeFileToDirectory(String filePath, String fileContents) {
        try {
            BufferedWriter writer = null;
            writer = new BufferedWriter(new FileWriter(filePath));
            writer.write(fileContents);
            writer.close();
        }
        catch (IOException ioe) {
            String error2 = "Could not create file in directory: \"" + filePath + "\".";
            logger.fatal(error2);
            throw new DocBuildException(error2);
        }
    }

    public static String fixIndexBaseName(String baseName) {
        if (baseName.equals("index")) {
            return "";
        }
        return baseName;
    }
}

