/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Stack;
import org.apache.commons.io.IOCase;

public class FilenameUtils {
    public static final char EXTENSION_SEPARATOR = '.';
    public static final String EXTENSION_SEPARATOR_STR = Character.toString('.');
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final char SYSTEM_SEPARATOR = File.separatorChar;
    private static final char OTHER_SEPARATOR = FilenameUtils.isSystemWindows() ? (char)47 : (char)92;

    static boolean isSystemWindows() {
        return SYSTEM_SEPARATOR == '\\';
    }

    private static boolean isSeparator(char ch) {
        return ch == '/' || ch == '\\';
    }

    public static String normalize(String filename2) {
        return FilenameUtils.doNormalize(filename2, SYSTEM_SEPARATOR, true);
    }

    public static String normalize(String filename2, boolean unixSeparator) {
        char separator = unixSeparator ? (char)'/' : '\\';
        return FilenameUtils.doNormalize(filename2, separator, true);
    }

    public static String normalizeNoEndSeparator(String filename2) {
        return FilenameUtils.doNormalize(filename2, SYSTEM_SEPARATOR, false);
    }

    public static String normalizeNoEndSeparator(String filename2, boolean unixSeparator) {
        char separator = unixSeparator ? (char)'/' : '\\';
        return FilenameUtils.doNormalize(filename2, separator, false);
    }

    private static String doNormalize(String filename2, char separator, boolean keepSeparator) {
        int i2;
        if (filename2 == null) {
            return null;
        }
        int size2 = filename2.length();
        if (size2 == 0) {
            return filename2;
        }
        int prefix = FilenameUtils.getPrefixLength(filename2);
        if (prefix < 0) {
            return null;
        }
        char[] array = new char[size2 + 2];
        filename2.getChars(0, filename2.length(), array, 0);
        char otherSeparator = separator == SYSTEM_SEPARATOR ? OTHER_SEPARATOR : SYSTEM_SEPARATOR;
        for (int i3 = 0; i3 < array.length; ++i3) {
            if (array[i3] != otherSeparator) continue;
            array[i3] = separator;
        }
        boolean lastIsDirectory = true;
        if (array[size2 - 1] != separator) {
            array[size2++] = separator;
            lastIsDirectory = false;
        }
        for (i2 = prefix + 1; i2 < size2; ++i2) {
            if (array[i2] != separator || array[i2 - 1] != separator) continue;
            System.arraycopy(array, i2, array, i2 - 1, size2 - i2);
            --size2;
            --i2;
        }
        for (i2 = prefix + 1; i2 < size2; ++i2) {
            if (array[i2] != separator || array[i2 - 1] != '.' || i2 != prefix + 1 && array[i2 - 2] != separator) continue;
            if (i2 == size2 - 1) {
                lastIsDirectory = true;
            }
            System.arraycopy(array, i2 + 1, array, i2 - 1, size2 - i2);
            size2 -= 2;
            --i2;
        }
        block3: for (i2 = prefix + 2; i2 < size2; ++i2) {
            if (array[i2] != separator || array[i2 - 1] != '.' || array[i2 - 2] != '.' || i2 != prefix + 2 && array[i2 - 3] != separator) continue;
            if (i2 == prefix + 2) {
                return null;
            }
            if (i2 == size2 - 1) {
                lastIsDirectory = true;
            }
            for (int j = i2 - 4; j >= prefix; --j) {
                if (array[j] != separator) continue;
                System.arraycopy(array, i2 + 1, array, j + 1, size2 - i2);
                size2 -= i2 - j;
                i2 = j + 1;
                continue block3;
            }
            System.arraycopy(array, i2 + 1, array, prefix, size2 - i2);
            size2 -= i2 + 1 - prefix;
            i2 = prefix + 1;
        }
        if (size2 <= 0) {
            return "";
        }
        if (size2 <= prefix) {
            return new String(array, 0, size2);
        }
        if (lastIsDirectory && keepSeparator) {
            return new String(array, 0, size2);
        }
        return new String(array, 0, size2 - 1);
    }

    public static String concat(String basePath, String fullFilenameToAdd) {
        int prefix = FilenameUtils.getPrefixLength(fullFilenameToAdd);
        if (prefix < 0) {
            return null;
        }
        if (prefix > 0) {
            return FilenameUtils.normalize(fullFilenameToAdd);
        }
        if (basePath == null) {
            return null;
        }
        int len = basePath.length();
        if (len == 0) {
            return FilenameUtils.normalize(fullFilenameToAdd);
        }
        char ch = basePath.charAt(len - 1);
        if (FilenameUtils.isSeparator(ch)) {
            return FilenameUtils.normalize(basePath + fullFilenameToAdd);
        }
        return FilenameUtils.normalize(basePath + '/' + fullFilenameToAdd);
    }

    public static boolean directoryContains(String canonicalParent, String canonicalChild) throws IOException {
        if (canonicalParent == null) {
            throw new IllegalArgumentException("Directory must not be null");
        }
        if (canonicalChild == null) {
            return false;
        }
        if (IOCase.SYSTEM.checkEquals(canonicalParent, canonicalChild)) {
            return false;
        }
        return IOCase.SYSTEM.checkStartsWith(canonicalChild, canonicalParent);
    }

    public static String separatorsToUnix(String path2) {
        if (path2 == null || path2.indexOf(92) == -1) {
            return path2;
        }
        return path2.replace('\\', '/');
    }

    public static String separatorsToWindows(String path2) {
        if (path2 == null || path2.indexOf(47) == -1) {
            return path2;
        }
        return path2.replace('/', '\\');
    }

    public static String separatorsToSystem(String path2) {
        if (path2 == null) {
            return null;
        }
        if (FilenameUtils.isSystemWindows()) {
            return FilenameUtils.separatorsToWindows(path2);
        }
        return FilenameUtils.separatorsToUnix(path2);
    }

    public static int getPrefixLength(String filename2) {
        if (filename2 == null) {
            return -1;
        }
        int len = filename2.length();
        if (len == 0) {
            return 0;
        }
        char ch0 = filename2.charAt(0);
        if (ch0 == ':') {
            return -1;
        }
        if (len == 1) {
            if (ch0 == '~') {
                return 2;
            }
            return FilenameUtils.isSeparator(ch0) ? 1 : 0;
        }
        if (ch0 == '~') {
            int posUnix = filename2.indexOf(47, 1);
            int posWin = filename2.indexOf(92, 1);
            if (posUnix == -1 && posWin == -1) {
                return len + 1;
            }
            posUnix = posUnix == -1 ? posWin : posUnix;
            posWin = posWin == -1 ? posUnix : posWin;
            return Math.min(posUnix, posWin) + 1;
        }
        char ch1 = filename2.charAt(1);
        if (ch1 == ':') {
            if ((ch0 = Character.toUpperCase(ch0)) >= 'A' && ch0 <= 'Z') {
                if (len == 2 || !FilenameUtils.isSeparator(filename2.charAt(2))) {
                    return 2;
                }
                return 3;
            }
            return -1;
        }
        if (FilenameUtils.isSeparator(ch0) && FilenameUtils.isSeparator(ch1)) {
            int posUnix = filename2.indexOf(47, 2);
            int posWin = filename2.indexOf(92, 2);
            if (posUnix == -1 && posWin == -1 || posUnix == 2 || posWin == 2) {
                return -1;
            }
            posUnix = posUnix == -1 ? posWin : posUnix;
            posWin = posWin == -1 ? posUnix : posWin;
            return Math.min(posUnix, posWin) + 1;
        }
        return FilenameUtils.isSeparator(ch0) ? 1 : 0;
    }

    public static int indexOfLastSeparator(String filename2) {
        if (filename2 == null) {
            return -1;
        }
        int lastUnixPos = filename2.lastIndexOf(47);
        int lastWindowsPos = filename2.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public static int indexOfExtension(String filename2) {
        if (filename2 == null) {
            return -1;
        }
        int extensionPos = filename2.lastIndexOf(46);
        int lastSeparator = FilenameUtils.indexOfLastSeparator(filename2);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    public static String getPrefix(String filename2) {
        if (filename2 == null) {
            return null;
        }
        int len = FilenameUtils.getPrefixLength(filename2);
        if (len < 0) {
            return null;
        }
        if (len > filename2.length()) {
            return filename2 + '/';
        }
        return filename2.substring(0, len);
    }

    public static String getPath(String filename2) {
        return FilenameUtils.doGetPath(filename2, 1);
    }

    public static String getPathNoEndSeparator(String filename2) {
        return FilenameUtils.doGetPath(filename2, 0);
    }

    private static String doGetPath(String filename2, int separatorAdd) {
        if (filename2 == null) {
            return null;
        }
        int prefix = FilenameUtils.getPrefixLength(filename2);
        if (prefix < 0) {
            return null;
        }
        int index2 = FilenameUtils.indexOfLastSeparator(filename2);
        int endIndex = index2 + separatorAdd;
        if (prefix >= filename2.length() || index2 < 0 || prefix >= endIndex) {
            return "";
        }
        return filename2.substring(prefix, endIndex);
    }

    public static String getFullPath(String filename2) {
        return FilenameUtils.doGetFullPath(filename2, true);
    }

    public static String getFullPathNoEndSeparator(String filename2) {
        return FilenameUtils.doGetFullPath(filename2, false);
    }

    private static String doGetFullPath(String filename2, boolean includeSeparator) {
        if (filename2 == null) {
            return null;
        }
        int prefix = FilenameUtils.getPrefixLength(filename2);
        if (prefix < 0) {
            return null;
        }
        if (prefix >= filename2.length()) {
            if (includeSeparator) {
                return FilenameUtils.getPrefix(filename2);
            }
            return filename2;
        }
        int index2 = FilenameUtils.indexOfLastSeparator(filename2);
        if (index2 < 0) {
            return filename2.substring(0, prefix);
        }
        int end2 = index2 + (includeSeparator ? 1 : 0);
        if (end2 == 0) {
            ++end2;
        }
        return filename2.substring(0, end2);
    }

    public static String getName(String filename2) {
        if (filename2 == null) {
            return null;
        }
        int index2 = FilenameUtils.indexOfLastSeparator(filename2);
        return filename2.substring(index2 + 1);
    }

    public static String getBaseName(String filename2) {
        return FilenameUtils.removeExtension(FilenameUtils.getName(filename2));
    }

    public static String getExtension(String filename2) {
        if (filename2 == null) {
            return null;
        }
        int index2 = FilenameUtils.indexOfExtension(filename2);
        if (index2 == -1) {
            return "";
        }
        return filename2.substring(index2 + 1);
    }

    public static String removeExtension(String filename2) {
        if (filename2 == null) {
            return null;
        }
        int index2 = FilenameUtils.indexOfExtension(filename2);
        if (index2 == -1) {
            return filename2;
        }
        return filename2.substring(0, index2);
    }

    public static boolean equals(String filename1, String filename2) {
        return FilenameUtils.equals(filename1, filename2, false, IOCase.SENSITIVE);
    }

    public static boolean equalsOnSystem(String filename1, String filename2) {
        return FilenameUtils.equals(filename1, filename2, false, IOCase.SYSTEM);
    }

    public static boolean equalsNormalized(String filename1, String filename2) {
        return FilenameUtils.equals(filename1, filename2, true, IOCase.SENSITIVE);
    }

    public static boolean equalsNormalizedOnSystem(String filename1, String filename2) {
        return FilenameUtils.equals(filename1, filename2, true, IOCase.SYSTEM);
    }

    public static boolean equals(String filename1, String filename2, boolean normalized, IOCase caseSensitivity) {
        if (filename1 == null || filename2 == null) {
            return filename1 == null && filename2 == null;
        }
        if (normalized) {
            filename1 = FilenameUtils.normalize(filename1);
            filename2 = FilenameUtils.normalize(filename2);
            if (filename1 == null || filename2 == null) {
                throw new NullPointerException("Error normalizing one or both of the file names");
            }
        }
        if (caseSensitivity == null) {
            caseSensitivity = IOCase.SENSITIVE;
        }
        return caseSensitivity.checkEquals(filename1, filename2);
    }

    public static boolean isExtension(String filename2, String extension) {
        if (filename2 == null) {
            return false;
        }
        if (extension == null || extension.length() == 0) {
            return FilenameUtils.indexOfExtension(filename2) == -1;
        }
        String fileExt = FilenameUtils.getExtension(filename2);
        return fileExt.equals(extension);
    }

    public static boolean isExtension(String filename2, String[] extensions) {
        if (filename2 == null) {
            return false;
        }
        if (extensions == null || extensions.length == 0) {
            return FilenameUtils.indexOfExtension(filename2) == -1;
        }
        String fileExt = FilenameUtils.getExtension(filename2);
        for (String extension : extensions) {
            if (!fileExt.equals(extension)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExtension(String filename2, Collection<String> extensions) {
        if (filename2 == null) {
            return false;
        }
        if (extensions == null || extensions.isEmpty()) {
            return FilenameUtils.indexOfExtension(filename2) == -1;
        }
        String fileExt = FilenameUtils.getExtension(filename2);
        for (String extension : extensions) {
            if (!fileExt.equals(extension)) continue;
            return true;
        }
        return false;
    }

    public static boolean wildcardMatch(String filename2, String wildcardMatcher) {
        return FilenameUtils.wildcardMatch(filename2, wildcardMatcher, IOCase.SENSITIVE);
    }

    public static boolean wildcardMatchOnSystem(String filename2, String wildcardMatcher) {
        return FilenameUtils.wildcardMatch(filename2, wildcardMatcher, IOCase.SYSTEM);
    }

    public static boolean wildcardMatch(String filename2, String wildcardMatcher, IOCase caseSensitivity) {
        if (filename2 == null && wildcardMatcher == null) {
            return true;
        }
        if (filename2 == null || wildcardMatcher == null) {
            return false;
        }
        if (caseSensitivity == null) {
            caseSensitivity = IOCase.SENSITIVE;
        }
        String[] wcs = FilenameUtils.splitOnTokens(wildcardMatcher);
        boolean anyChars = false;
        int textIdx = 0;
        int wcsIdx = 0;
        Stack<int[]> backtrack = new Stack<int[]>();
        do {
            if (backtrack.size() > 0) {
                int[] array = (int[])backtrack.pop();
                wcsIdx = array[0];
                textIdx = array[1];
                anyChars = true;
            }
            while (wcsIdx < wcs.length) {
                if (wcs[wcsIdx].equals("?")) {
                    if (++textIdx > filename2.length()) break;
                    anyChars = false;
                } else if (wcs[wcsIdx].equals("*")) {
                    anyChars = true;
                    if (wcsIdx == wcs.length - 1) {
                        textIdx = filename2.length();
                    }
                } else {
                    if (anyChars) {
                        if ((textIdx = caseSensitivity.checkIndexOf(filename2, textIdx, wcs[wcsIdx])) == -1) break;
                        int repeat = caseSensitivity.checkIndexOf(filename2, textIdx + 1, wcs[wcsIdx]);
                        if (repeat >= 0) {
                            backtrack.push(new int[]{wcsIdx, repeat});
                        }
                    } else if (!caseSensitivity.checkRegionMatches(filename2, textIdx, wcs[wcsIdx])) break;
                    textIdx += wcs[wcsIdx].length();
                    anyChars = false;
                }
                ++wcsIdx;
            }
            if (wcsIdx != wcs.length || textIdx != filename2.length()) continue;
            return true;
        } while (backtrack.size() > 0);
        return false;
    }

    static String[] splitOnTokens(String text) {
        if (text.indexOf(63) == -1 && text.indexOf(42) == -1) {
            return new String[]{text};
        }
        char[] array = text.toCharArray();
        ArrayList<String> list2 = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (array[i2] == '?' || array[i2] == '*') {
                if (buffer.length() != 0) {
                    list2.add(buffer.toString());
                    buffer.setLength(0);
                }
                if (array[i2] == '?') {
                    list2.add("?");
                    continue;
                }
                if (!list2.isEmpty() && (i2 <= 0 || ((String)list2.get(list2.size() - 1)).equals("*"))) continue;
                list2.add("*");
                continue;
            }
            buffer.append(array[i2]);
        }
        if (buffer.length() != 0) {
            list2.add(buffer.toString());
        }
        return list2.toArray(new String[list2.size()]);
    }
}

