/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

public class CharSequenceUtils {
    public static CharSequence subSequence(CharSequence cs, int start2) {
        return cs == null ? null : cs.subSequence(start2, cs.length());
    }

    static int indexOf(CharSequence cs, int searchChar, int start2) {
        if (cs instanceof String) {
            return ((String)cs).indexOf(searchChar, start2);
        }
        int sz = cs.length();
        if (start2 < 0) {
            start2 = 0;
        }
        for (int i2 = start2; i2 < sz; ++i2) {
            if (cs.charAt(i2) != searchChar) continue;
            return i2;
        }
        return -1;
    }

    static int indexOf(CharSequence cs, CharSequence searchChar, int start2) {
        return cs.toString().indexOf(searchChar.toString(), start2);
    }

    static int lastIndexOf(CharSequence cs, int searchChar, int start2) {
        if (cs instanceof String) {
            return ((String)cs).lastIndexOf(searchChar, start2);
        }
        int sz = cs.length();
        if (start2 < 0) {
            return -1;
        }
        if (start2 >= sz) {
            start2 = sz - 1;
        }
        for (int i2 = start2; i2 >= 0; --i2) {
            if (cs.charAt(i2) != searchChar) continue;
            return i2;
        }
        return -1;
    }

    static int lastIndexOf(CharSequence cs, CharSequence searchChar, int start2) {
        return cs.toString().lastIndexOf(searchChar.toString(), start2);
    }

    static char[] toCharArray(CharSequence cs) {
        if (cs instanceof String) {
            return ((String)cs).toCharArray();
        }
        int sz = cs.length();
        char[] array = new char[cs.length()];
        for (int i2 = 0; i2 < sz; ++i2) {
            array[i2] = cs.charAt(i2);
        }
        return array;
    }

    static boolean regionMatches(CharSequence cs, boolean ignoreCase, int thisStart, CharSequence substring, int start2, int length2) {
        if (cs instanceof String && substring instanceof String) {
            return ((String)cs).regionMatches(ignoreCase, thisStart, (String)substring, start2, length2);
        }
        int index1 = thisStart;
        int index2 = start2;
        int tmpLen = length2;
        while (tmpLen-- > 0) {
            char c2;
            char c1;
            if ((c1 = cs.charAt(index1++)) == (c2 = substring.charAt(index2++))) continue;
            if (!ignoreCase) {
                return false;
            }
            if (Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }
}

