/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.pattern;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.helpers.PatternConverter;
import org.apache.log4j.pattern.FormattingInfo;
import org.apache.log4j.pattern.LiteralPatternConverter;
import org.apache.log4j.pattern.LoggingEventPatternConverter;
import org.apache.log4j.pattern.PatternParser;
import org.apache.log4j.spi.LoggingEvent;

public final class BridgePatternConverter
extends PatternConverter {
    private LoggingEventPatternConverter[] patternConverters;
    private FormattingInfo[] patternFields;
    private boolean handlesExceptions;

    public BridgePatternConverter(String pattern) {
        this.next = null;
        this.handlesExceptions = false;
        ArrayList converters = new ArrayList();
        ArrayList fields2 = new ArrayList();
        Map converterRegistry = null;
        PatternParser.parse(pattern, converters, fields2, converterRegistry, PatternParser.getPatternLayoutRules());
        this.patternConverters = new LoggingEventPatternConverter[converters.size()];
        this.patternFields = new FormattingInfo[converters.size()];
        int i2 = 0;
        Iterator converterIter = converters.iterator();
        Iterator fieldIter = fields2.iterator();
        while (converterIter.hasNext()) {
            Object converter = converterIter.next();
            if (converter instanceof LoggingEventPatternConverter) {
                this.patternConverters[i2] = (LoggingEventPatternConverter)converter;
                this.handlesExceptions |= this.patternConverters[i2].handlesThrowable();
            } else {
                this.patternConverters[i2] = new LiteralPatternConverter("");
            }
            this.patternFields[i2] = fieldIter.hasNext() ? (FormattingInfo)fieldIter.next() : FormattingInfo.getDefault();
            ++i2;
        }
    }

    protected String convert(LoggingEvent event2) {
        StringBuffer sbuf = new StringBuffer();
        this.format(sbuf, event2);
        return sbuf.toString();
    }

    public void format(StringBuffer sbuf, LoggingEvent e) {
        for (int i2 = 0; i2 < this.patternConverters.length; ++i2) {
            int startField = sbuf.length();
            this.patternConverters[i2].format(e, sbuf);
            this.patternFields[i2].format(startField, sbuf);
        }
    }

    public boolean ignoresThrowable() {
        return !this.handlesExceptions;
    }
}

