/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.pattern;

import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.MDCKeySetExtractor;
import org.apache.log4j.pattern.LoggingEventPatternConverter;
import org.apache.log4j.spi.LoggingEvent;

public final class PropertiesPatternConverter
extends LoggingEventPatternConverter {
    private final String option;

    private PropertiesPatternConverter(String[] options2) {
        super(options2 != null && options2.length > 0 ? "Property{" + options2[0] + "}" : "Properties", "property");
        this.option = options2 != null && options2.length > 0 ? options2[0] : null;
    }

    public static PropertiesPatternConverter newInstance(String[] options2) {
        return new PropertiesPatternConverter(options2);
    }

    public void format(LoggingEvent event2, StringBuffer toAppendTo) {
        if (this.option == null) {
            toAppendTo.append("{");
            try {
                Set keySet = MDCKeySetExtractor.INSTANCE.getPropertyKeySet(event2);
                if (keySet != null) {
                    Iterator i2 = keySet.iterator();
                    while (i2.hasNext()) {
                        Object item = i2.next();
                        Object val = event2.getMDC(item.toString());
                        toAppendTo.append("{").append(item).append(",").append(val).append("}");
                    }
                }
            }
            catch (Exception ex) {
                LogLog.error("Unexpected exception while extracting MDC keys", ex);
            }
            toAppendTo.append("}");
        } else {
            Object val = event2.getMDC(this.option);
            if (val != null) {
                toAppendTo.append(val);
            }
        }
    }
}

