/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.ast;

import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import org.asciidoctor.ast.AbstractBlockImpl;
import org.asciidoctor.ast.Column;
import org.asciidoctor.ast.Row;
import org.asciidoctor.ast.RowImpl;
import org.asciidoctor.ast.Table;
import org.asciidoctor.internal.RubyBlockListDecorator;
import org.asciidoctor.internal.RubyObjectWrapper;
import org.jruby.RubyArray;
import org.jruby.RubyNil;
import org.jruby.runtime.builtin.IRubyObject;

public class TableImpl
extends AbstractBlockImpl
implements Table {
    private static final String FRAME_ATTR = "frame";
    private static final String GRID_ATTR = "grid";
    private Rows rows = new Rows(this.getRubyProperty("rows", new Object[0]));

    public TableImpl(IRubyObject rubyObject) {
        super(rubyObject);
    }

    @Override
    public boolean hasHeaderOption() {
        return this.getBoolean("has_header_option", new Object[0]);
    }

    @Override
    public String getFrame() {
        return (String)this.getAttr(FRAME_ATTR, "all");
    }

    @Override
    public void setFrame(String frame) {
        this.setAttr(FRAME_ATTR, frame, true);
    }

    @Override
    public String getGrid() {
        return (String)this.getAttr(GRID_ATTR, "all");
    }

    @Override
    public void setGrid(String grid) {
        this.setAttr(GRID_ATTR, grid, true);
    }

    @Override
    public List<Column> getColumns() {
        RubyArray rubyBlocks = (RubyArray)this.getRubyProperty("columns", new Object[0]);
        return new RubyBlockListDecorator<Column>(rubyBlocks);
    }

    @Override
    public List<Row> getFooter() {
        return this.rows.getFooter();
    }

    @Override
    public List<Row> getBody() {
        return this.rows.getBody();
    }

    @Override
    public List<Row> getHeader() {
        return this.rows.getHeader();
    }

    class RowList
    extends AbstractList<Row> {
        private final RubyArray rubyArray;

        private RowList(RubyArray rubyArray) {
            this.rubyArray = rubyArray;
        }

        @Override
        public int size() {
            return this.rubyArray.size();
        }

        @Override
        public boolean isEmpty() {
            return this.rubyArray.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            if (!RowImpl.class.isInstance(o)) {
                return false;
            }
            return this.rubyArray.contains(((RowImpl)o).getRubyObject());
        }

        @Override
        public boolean add(Row row) {
            boolean changed = this.rubyArray.add(((RowImpl)row).getRubyObject());
            TableImpl.this.setAttr("rowcount", this.size(), true);
            return changed;
        }

        @Override
        public boolean remove(Object o) {
            if (!RowImpl.class.isInstance(o)) {
                return false;
            }
            boolean changed = this.rubyArray.remove(((RowImpl)o).getRubyObject());
            TableImpl.this.setAttr("rowcount", this.size(), true);
            return changed;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.rubyArray.clear();
            TableImpl.this.setAttr("rowcount", this.size(), true);
        }

        @Override
        public Row get(int index2) {
            IRubyObject o = this.rubyArray.at(this.rubyArray.getRuntime().newFixnum(index2));
            if (o == null || o instanceof RubyNil) {
                return null;
            }
            return new RowImpl(o);
        }

        @Override
        public Row set(int index2, Row element) {
            Row oldRow = this.get(index2);
            this.rubyArray.set(index2, ((RowImpl)element).getRubyObject());
            return oldRow;
        }

        @Override
        public void add(int index2, Row element) {
            this.rubyArray.add(index2, ((RowImpl)element).getRubyObject());
            TableImpl.this.setAttr("rowcount", this.size(), true);
        }

        @Override
        public Row remove(int index2) {
            IRubyObject rubyObject = (IRubyObject)this.rubyArray.remove(index2);
            TableImpl.this.setAttr("rowcount", this.size(), true);
            return new RowImpl(rubyObject);
        }

        @Override
        public int indexOf(Object o) {
            if (!RowImpl.class.isInstance(o)) {
                return -1;
            }
            return this.rubyArray.indexOf(((RowImpl)o).getRubyObject());
        }

        @Override
        public int lastIndexOf(Object o) {
            if (!RowImpl.class.isInstance(o)) {
                return -1;
            }
            return this.rubyArray.lastIndexOf(((RowImpl)o).getRubyObject());
        }
    }

    private class Rows
    extends RubyObjectWrapper {
        public Rows(IRubyObject rubyNode) {
            super(rubyNode);
        }

        private RowList getHeader() {
            RubyArray headerRows = (RubyArray)this.getRubyProperty("head", new Object[0]);
            return new RowList(headerRows);
        }

        private RowList getBody() {
            RubyArray bodyRows = (RubyArray)this.getRubyProperty("body", new Object[0]);
            return new RowList(bodyRows);
        }

        private RowList getFooter() {
            RubyArray footerRows = (RubyArray)this.getRubyProperty("foot", new Object[0]);
            return new RowList(footerRows);
        }

        private void setFooterRow(Row row) {
            RubyArray newFooterRows = this.getRuntime().newArray((IRubyObject)((RowImpl)row).getRubyCells());
            this.getRubyObject().getInstanceVariables().setInstanceVariable("@foot", newFooterRows);
        }
    }
}

