/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.extension;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.asciidoctor.ast.AbstractBlock;
import org.asciidoctor.ast.AbstractBlockImpl;
import org.asciidoctor.ast.Block;
import org.asciidoctor.ast.Cell;
import org.asciidoctor.ast.Column;
import org.asciidoctor.ast.ColumnImpl;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.DocumentImpl;
import org.asciidoctor.ast.Inline;
import org.asciidoctor.ast.NodeConverter;
import org.asciidoctor.ast.Row;
import org.asciidoctor.ast.RowImpl;
import org.asciidoctor.ast.Table;
import org.asciidoctor.extension.Reader;
import org.asciidoctor.extension.ReaderImpl;
import org.asciidoctor.internal.JRubyRuntimeContext;
import org.asciidoctor.internal.RubyHashUtil;
import org.asciidoctor.internal.RubyObjectWrapper;
import org.asciidoctor.internal.RubyUtils;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.runtime.builtin.IRubyObject;

public class Processor {
    public static final String CONTENT_MODEL = "content_model";
    public static final String CONTENT_MODEL_COMPOUND = ":compound";
    public static final String CONTENT_MODEL_SIMPLE = ":simple";
    public static final String CONTENT_MODEL_VERBATIM = ":verbatim";
    public static final String CONTENT_MODEL_RAW = ":raw";
    public static final String CONTENT_MODEL_SKIP = ":skip";
    public static final String CONTENT_MODEL_EMPTY = ":empty";
    public static final String CONTENT_MODEL_ATTRIBUTES = ":attributes";
    protected Map<String, Object> config;
    private boolean configFinalized = false;

    public Processor() {
        this(new HashMap<String, Object>());
    }

    public Processor(Map<String, Object> config) {
        this.config = new HashMap<String, Object>(config);
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public final void setConfig(Map<String, Object> config) {
        if (this.configFinalized) {
            throw new IllegalStateException("It is only allowed to set the config in the constructor!");
        }
        this.config = config;
    }

    public final void setConfigFinalized() {
        this.configFinalized = true;
    }

    public Table createTable(AbstractBlock parent) {
        return this.createTable(parent, new HashMap<String, Object>());
    }

    public Table createTable(AbstractBlock parent, Map<String, Object> attributes) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(parent);
        RubyHash rubyAttributes = RubyHash.newHash(rubyRuntime);
        rubyAttributes.putAll(attributes);
        IRubyObject[] parameters2 = new IRubyObject[]{((AbstractBlockImpl)parent).getRubyObject(), rubyAttributes};
        Table ret = (Table)NodeConverter.createASTNode(rubyRuntime, NodeConverter.NodeType.TABLE_CLASS, parameters2);
        ret.setAttr("rowcount", 0, false);
        return ret;
    }

    public Row createTableRow(Table parent) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(parent);
        RubyArray rubyRow = rubyRuntime.newArray();
        return new RowImpl(rubyRow);
    }

    public Column createTableColumn(Table parent, int index2) {
        return this.createTableColumn(parent, index2, new HashMap<String, Object>());
    }

    public Column createTableColumn(Table parent, int index2, Map<String, Object> attributes) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(parent);
        RubyHash rubyAttributes = RubyHash.newHash(rubyRuntime);
        rubyAttributes.putAll(attributes);
        IRubyObject[] parameters2 = new IRubyObject[]{((AbstractBlockImpl)((Object)parent)).getRubyObject(), RubyFixnum.newFixnum(rubyRuntime, index2), rubyAttributes};
        return (Column)NodeConverter.createASTNode(rubyRuntime, NodeConverter.NodeType.TABLE_COLUMN_CLASS, parameters2);
    }

    public Cell createTableCell(Column column, String text) {
        return this.createTableCell(column, text, new HashMap<String, Object>());
    }

    public Cell createTableCell(Column column, Document innerDocument) {
        return this.createTableCell(column, innerDocument, new HashMap<String, Object>());
    }

    public Cell createTableCell(Column column, Document innerDocument, Map<String, Object> attributes) {
        Cell cell = this.createTableCell(column, (String)null, attributes);
        cell.setStyle("asciidoc");
        cell.setInnerDocument(innerDocument);
        return cell;
    }

    public Cell createTableCell(Column column, String text, Map<String, Object> attributes) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(column);
        RubyHash rubyAttributes = RubyHash.newHash(rubyRuntime);
        rubyAttributes.putAll(attributes);
        IRubyObject[] parameters2 = new IRubyObject[]{((ColumnImpl)column).getRubyObject(), text != null ? rubyRuntime.newString(text) : rubyRuntime.getNil(), rubyAttributes};
        return (Cell)NodeConverter.createASTNode(rubyRuntime, NodeConverter.NodeType.TABLE_CELL_CLASS, parameters2);
    }

    public Block createBlock(AbstractBlock parent, String context, String content) {
        return this.createBlock(parent, context, content, new HashMap<String, Object>(), new HashMap<Object, Object>());
    }

    public Block createBlock(AbstractBlock parent, String context, String content, Map<String, Object> attributes) {
        return this.createBlock(parent, context, content, attributes, new HashMap<Object, Object>());
    }

    public Block createBlock(AbstractBlock parent, String context, String content, Map<String, Object> attributes, Map<Object, Object> options2) {
        options2.put("source", content);
        options2.put("attributes", attributes);
        return this.createBlock(parent, context, options2);
    }

    public Block createBlock(AbstractBlock parent, String context, List<String> content) {
        return this.createBlock(parent, context, content, new HashMap<String, Object>(), new HashMap<Object, Object>());
    }

    public Block createBlock(AbstractBlock parent, String context, List<String> content, Map<String, Object> attributes) {
        return this.createBlock(parent, context, content, attributes, new HashMap<Object, Object>());
    }

    public Block createBlock(AbstractBlock parent, String context, List<String> content, Map<String, Object> attributes, Map<Object, Object> options2) {
        options2.put("source", content);
        options2.put("attributes", new HashMap<String, Object>(attributes));
        return this.createBlock(parent, context, options2);
    }

    public Inline createInline(AbstractBlock parent, String context, List<String> text) {
        return this.createInline(parent, context, text, new HashMap<String, Object>());
    }

    public Inline createInline(AbstractBlock parent, String context, List<String> text, Map<String, Object> attributes) {
        return this.createInline(parent, context, text, attributes, new HashMap<Object, Object>());
    }

    public Inline createInline(AbstractBlock parent, String context, List<String> text, Map<String, Object> attributes, Map<Object, Object> options2) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(parent);
        options2.put("attributes", attributes);
        RubyHash convertMapToRubyHashWithSymbols = RubyHashUtil.convertMapToRubyHashWithSymbolsIfNecessary(rubyRuntime, options2);
        RubyArray rubyText = rubyRuntime.newArray();
        rubyText.addAll(text);
        IRubyObject[] parameters2 = new IRubyObject[]{((AbstractBlockImpl)parent).getRubyObject(), RubyUtils.toSymbol(rubyRuntime, context), rubyText, convertMapToRubyHashWithSymbols};
        return (Inline)NodeConverter.createASTNode(rubyRuntime, NodeConverter.NodeType.INLINE_CLASS, parameters2);
    }

    public Inline createInline(AbstractBlock parent, String context, String text) {
        return this.createInline(parent, context, text, new HashMap<String, Object>());
    }

    public Inline createInline(AbstractBlock parent, String context, String text, Map<String, Object> attributes) {
        return this.createInline(parent, context, text, attributes, new HashMap<String, Object>());
    }

    public Inline createInline(AbstractBlock parent, String context, String text, Map<String, Object> attributes, Map<String, Object> options2) {
        options2.put("attributes", attributes);
        Ruby rubyRuntime = JRubyRuntimeContext.get(parent);
        RubyHash convertedOptions = RubyHashUtil.convertMapToRubyHashWithSymbols(rubyRuntime, options2);
        IRubyObject[] parameters2 = new IRubyObject[]{((AbstractBlockImpl)parent).getRubyObject(), RubyUtils.toSymbol(rubyRuntime, context), rubyRuntime.newString(text), convertedOptions};
        return (Inline)NodeConverter.createASTNode(rubyRuntime, NodeConverter.NodeType.INLINE_CLASS, parameters2);
    }

    private Block createBlock(AbstractBlock parent, String context, Map<Object, Object> options2) {
        Ruby rubyRuntime = JRubyRuntimeContext.get(parent);
        RubyHash convertMapToRubyHashWithSymbols = RubyHashUtil.convertMapToRubyHashWithSymbolsIfNecessary(rubyRuntime, options2);
        IRubyObject[] parameters2 = new IRubyObject[]{((AbstractBlockImpl)parent).getRubyObject(), RubyUtils.toSymbol(rubyRuntime, context), convertMapToRubyHashWithSymbols};
        return (Block)NodeConverter.createASTNode(rubyRuntime, NodeConverter.NodeType.BLOCK_CLASS, parameters2);
    }

    public Document createDocument(Document parentDocument) {
        Ruby runtime = JRubyRuntimeContext.get(parentDocument);
        RubyHash options2 = RubyHash.newHash(runtime);
        options2.put(runtime.newSymbol("parent"), ((DocumentImpl)parentDocument).getRubyObject());
        return (Document)NodeConverter.createASTNode(runtime, NodeConverter.NodeType.DOCUMENT_CLASS, runtime.getNil(), options2);
    }

    public void parseContent(AbstractBlock parent, List<String> lines2) {
        Ruby runtime = JRubyRuntimeContext.get(parent);
        Parser parser = new Parser(runtime, parent, ReaderImpl.createReader(runtime, lines2));
        AbstractBlock nextBlock = parser.nextBlock();
        while (nextBlock != null) {
            parent.append(nextBlock);
            nextBlock = parser.nextBlock();
        }
    }

    private class Parser
    extends RubyObjectWrapper {
        private final Reader reader;
        private final AbstractBlock parent;

        public Parser(Ruby runtime, AbstractBlock parent, Reader reader) {
            super(runtime.getModule("Asciidoctor").getClass("Parser"));
            this.reader = reader;
            this.parent = parent;
        }

        public AbstractBlock nextBlock() {
            if (!this.reader.hasMoreLines()) {
                return null;
            }
            IRubyObject nextBlock = this.getRubyProperty("next_block", this.reader, ((AbstractBlockImpl)this.parent).getRubyObject());
            if (nextBlock.isNil()) {
                return null;
            }
            return (AbstractBlock)NodeConverter.createASTNode(nextBlock);
        }
    }
}

