/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.asciidoctor.SafeMode;

public class AsciidoctorUtils {
    private static final String RUNNER = "asciidoctor";

    private AsciidoctorUtils() {
    }

    public static boolean isOptionWithAttribute(Map<String, Object> options2, String attributeName, String attributeValue) {
        String configuredAttributeValue;
        Map attributes;
        return options2.containsKey("attributes") && (attributes = (Map)options2.get("attributes")).containsKey(attributeName) && (configuredAttributeValue = (String)attributes.get(attributeName)).equals(attributeValue);
    }

    public static String toAsciidoctorCommand(Map<String, Object> options2, String inputPath) {
        String command = "asciidoctor " + AsciidoctorUtils.getOptions(options2) + inputPath;
        return command;
    }

    private static String getOptions(Map<String, Object> options2) {
        StringBuilder optionsAndAttributes = new StringBuilder();
        if (options2.containsKey("destination_dir")) {
            optionsAndAttributes.append("-D").append(" ").append(options2.get("destination_dir")).append(" ");
        }
        if (options2.containsKey("base_dir")) {
            optionsAndAttributes.append("-B").append(" ").append(options2.get("base_dir")).append(" ");
        }
        if (options2.containsKey("template_dirs")) {
            List templates = (List)options2.get("template_dirs");
            for (String template : templates) {
                optionsAndAttributes.append("-T").append(" ").append(template).append(" ");
            }
        }
        if (options2.containsKey("template_engine")) {
            optionsAndAttributes.append("-E").append(" ").append(options2.get("template_engine")).append(" ");
        }
        if (options2.containsKey("compact")) {
            optionsAndAttributes.append("-C").append(" ");
        }
        if (options2.containsKey("eruby")) {
            optionsAndAttributes.append("-e").append(" ").append(options2.get("eruby")).append(" ");
        }
        if (options2.containsKey("header_footer")) {
            optionsAndAttributes.append("-s").append(" ");
        }
        if (options2.containsKey("safe")) {
            Integer level2 = (Integer)options2.get("safe");
            SafeMode getSafeMode = SafeMode.safeMode(level2);
            optionsAndAttributes.append("-S").append(" ").append((Object)getSafeMode).append(" ");
        }
        if (options2.containsKey("to_file")) {
            optionsAndAttributes.append("-o").append(" ").append(options2.get("to_file")).append(" ");
        }
        if (options2.containsKey("doctype")) {
            optionsAndAttributes.append("-d").append(" ").append(options2.get("doctype")).append(" ");
        }
        if (options2.containsKey("backend")) {
            optionsAndAttributes.append("-b").append(" ").append(options2.get("backend")).append(" ");
        }
        if (options2.containsKey("attributes")) {
            optionsAndAttributes.append(AsciidoctorUtils.getAttributesSyntax((Map)options2.get("attributes")));
        }
        return optionsAndAttributes.toString();
    }

    private static String getAttributesSyntax(Map<String, Object> attributes) {
        StringBuilder attributesOutput = new StringBuilder();
        Set<Map.Entry<String, Object>> entrySet = attributes.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            attributesOutput.append(AsciidoctorUtils.getAttributeSyntax(entry.getKey(), entry.getValue())).append(" ");
        }
        return attributesOutput.toString();
    }

    private static String getAttributeSyntax(String attributeName, Object attributeValue) {
        String attribute = "-a " + attributeName;
        if (attributeValue != null && !"".equals(attributeValue.toString().trim())) {
            attribute = attribute + "=" + attributeValue.toString();
        }
        if (attributeValue == null) {
            attribute = attribute + "!";
        }
        return attribute;
    }
}

