/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.internal;

import java.util.ArrayList;
import java.util.List;
import org.asciidoctor.internal.RubyUtils;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyObjectWrapper {
    protected Ruby runtime;
    protected IRubyObject rubyNode;

    public RubyObjectWrapper(IRubyObject rubyNode) {
        this.rubyNode = rubyNode;
        this.runtime = rubyNode.getRuntime();
    }

    public IRubyObject getRubyObject() {
        return this.rubyNode;
    }

    protected Ruby getRuntime() {
        return this.runtime;
    }

    protected String getString(String propertyName, Object ... args2) {
        IRubyObject result2 = this.getRubyProperty(propertyName, args2);
        if (result2 instanceof RubyNil) {
            return null;
        }
        if (result2 instanceof RubySymbol) {
            return ((RubySymbol)result2).asJavaString();
        }
        return ((RubyString)result2).asJavaString();
    }

    protected void setString(String propertyName, String value2) {
        if (value2 == null) {
            this.setRubyProperty(propertyName, this.runtime.getNil());
        } else {
            this.setRubyProperty(propertyName, this.runtime.newString(value2));
        }
    }

    protected String getSymbol(String propertyName, Object ... args2) {
        IRubyObject result2 = this.getRubyProperty(propertyName, args2);
        if (result2 instanceof RubyNil) {
            return null;
        }
        return ((RubySymbol)result2).asJavaString();
    }

    protected void setSymbol(String propertyName, String value2) {
        if (value2 == null) {
            this.setRubyProperty(propertyName, this.runtime.getNil());
        } else {
            this.setRubyProperty(propertyName, this.runtime.newSymbol(value2));
        }
    }

    protected boolean getBoolean(String propertyName, Object ... args2) {
        IRubyObject result2 = this.getRubyProperty(propertyName, args2);
        if (result2 instanceof RubyNil) {
            return false;
        }
        return ((RubyBoolean)result2).isTrue();
    }

    protected int getInt(String propertyName, Object ... args2) {
        IRubyObject result2 = this.getRubyProperty(propertyName, args2);
        if (result2 instanceof RubyNil) {
            return 0;
        }
        return (int)((RubyNumeric)result2).getLongValue();
    }

    protected <T> List<T> getList(String propertyName, Class<T> elementClass, Object ... args2) {
        IRubyObject result2 = this.getRubyProperty(propertyName, args2);
        if (result2 instanceof RubyNil) {
            return null;
        }
        ArrayList<T> ret = new ArrayList<T>();
        RubyArray array = (RubyArray)result2;
        for (int i2 = 0; i2 < array.size(); ++i2) {
            ret.add(RubyUtils.rubyToJava(this.runtime, array.at(RubyFixnum.newFixnum(this.runtime, i2)), elementClass));
        }
        return ret;
    }

    protected IRubyObject getRubyProperty(String propertyName, Object ... args2) {
        ThreadContext threadContext = this.runtime.getThreadService().getCurrentContext();
        IRubyObject result2 = null;
        if (propertyName.startsWith("@")) {
            if (args2 != null) {
                throw new IllegalArgumentException("No args allowed for direct field access");
            }
            result2 = this.rubyNode.getInstanceVariables().getInstanceVariable(propertyName);
        } else if (args2 == null) {
            result2 = this.rubyNode.callMethod(threadContext, propertyName);
        } else {
            IRubyObject[] rubyArgs = new IRubyObject[args2.length];
            for (int i2 = 0; i2 < args2.length; ++i2) {
                rubyArgs[i2] = args2[i2] instanceof RubyObjectWrapper ? ((RubyObjectWrapper)args2[i2]).getRubyObject() : JavaEmbedUtils.javaToRuby(this.runtime, args2[i2]);
            }
            result2 = this.rubyNode.callMethod(threadContext, propertyName, rubyArgs);
        }
        return result2;
    }

    protected void setRubyProperty(String propertyName, IRubyObject arg2) {
        ThreadContext threadContext = this.runtime.getThreadService().getCurrentContext();
        Object result2 = null;
        if (propertyName.startsWith("@")) {
            this.rubyNode.getInstanceVariables().setInstanceVariable(propertyName, arg2);
        } else if (arg2 == null) {
            this.rubyNode.callMethod(threadContext, propertyName + "=", this.runtime.getNil());
        } else {
            this.rubyNode.callMethod(threadContext, propertyName + "=", arg2);
        }
    }

    protected Object getProperty(String propertyName, Object ... args2) {
        return this.toJava(this.getRubyProperty(propertyName, args2));
    }

    protected Object toJava(IRubyObject rubyObject) {
        return JavaEmbedUtils.rubyToJava(rubyObject);
    }

    protected <T> T toJava(IRubyObject rubyObject, Class<T> targetClass) {
        return (T)JavaEmbedUtils.rubyToJava(this.runtime, rubyObject, targetClass);
    }
}

