/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.util.ArrayList;
import java.util.List;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.helper.HttpConnection;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormElement
extends Element {
    private final Elements elements = new Elements();

    public FormElement(Tag tag2, String baseUri, Attributes attributes) {
        super(tag2, baseUri, attributes);
    }

    public Elements elements() {
        return this.elements;
    }

    public FormElement addElement(Element element) {
        this.elements.add(element);
        return this;
    }

    public Connection submit() {
        String action = this.hasAttr("action") ? this.absUrl("action") : this.baseUri();
        Validate.notEmpty(action, "Could not determine a form action URL for submit. Ensure you set a base URI when parsing.");
        Connection.Method method2 = this.attr("method").toUpperCase().equals("POST") ? Connection.Method.POST : Connection.Method.GET;
        Connection con = Jsoup.connect(action).data(this.formData()).method(method2);
        return con;
    }

    public List<Connection.KeyVal> formData() {
        ArrayList<Connection.KeyVal> data2 = new ArrayList<Connection.KeyVal>();
        for (Element el : this.elements) {
            String name2;
            if (!el.tag().isFormSubmittable() || (name2 = el.attr("name")).length() == 0) continue;
            if ("select".equals(el.tagName())) {
                Elements options2 = el.select("option[selected]");
                for (Element option : options2) {
                    data2.add(HttpConnection.KeyVal.create(name2, option.val()));
                }
                continue;
            }
            data2.add(HttpConnection.KeyVal.create(name2, el.val()));
        }
        return data2;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }
}

