/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.documentation.builder.previewer;

import com.mulesoft.documentation.builder.AsciiDocProcessor;
import com.mulesoft.documentation.builder.util.Utilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.asciidoctor.ast.Block;
import org.asciidoctor.ast.StructuralNode;
import org.asciidoctor.extension.BlockProcessor;
import org.asciidoctor.extension.ContentModel;
import org.asciidoctor.extension.Contexts;
import org.asciidoctor.extension.Reader;

@Contexts(value={":listing"})
@ContentModel(value=":compound")
public class TabProcessor
extends BlockProcessor {
    private AsciiDocProcessor processor = AsciiDocProcessor.getProcessorInstance();

    public Object process(StructuralNode parent, Reader reader, Map<String, Object> attributes) {
        HashMap inherited = new HashMap();
        Block container = this.createBlock(parent, "open", null, inherited, new HashMap());
        LinkedHashMap<String, String> titleAndId = new LinkedHashMap<String, String>();
        int count = 0;
        this.parseContent((StructuralNode)container, reader.readLines());
        for (int i = 0; i < container.getBlocks().size(); ++i) {
            StructuralNode child = (StructuralNode)container.getBlocks().get(i);
            String tabTitle = child.getTitle();
            String uniqueId = Utilities.cleanPageFileNames((String)tabTitle) + "-" + Utilities.getRandomAlphaNumericString((int)5);
            titleAndId.put(tabTitle, uniqueId);
            String singleTabHtmlOpen = count == 0 ? "<div class=\"tab-pane in active fade no-padding\" id=\"" + uniqueId + "\">" : "<div class=\"tab-pane fade no-padding\" id=\"" + uniqueId + "\">";
            String converted = this.processor.convertAsciiDocString(child.content().toString());
            converted = Utilities.getOnlyContentDivFromHtml((String)converted);
            converted = singleTabHtmlOpen + converted + "</div>";
            Block block = this.createBlock(parent, "pass", converted, inherited, new HashMap());
            ++count;
            container.getBlocks().set(i, block);
        }
        String tabsOpen = "<div class=\"panel panel-default no-padding\">\n    <div class=\"panel-heading no-padding\">\n        <!-- Nav tabs -->\n        <ul class=\"nav nav-tabs\" role=\"tablist\">\n";
        ArrayList randAccess = new ArrayList(titleAndId.entrySet());
        for (int i = 0; i < titleAndId.size(); ++i) {
            if (i == 0) {
                tabsOpen = tabsOpen + "<li class=\"active\">";
                tabsOpen = tabsOpen + "<a href=\"#" + (String)((Map.Entry)randAccess.get(i)).getValue() + "\" role=\"tab\" data-toggle=\"tab\">" + (String)((Map.Entry)randAccess.get(i)).getKey() + "</a></li>\n";
                continue;
            }
            tabsOpen = tabsOpen + "<li><a href=\"#" + (String)((Map.Entry)randAccess.get(i)).getValue() + "\" role=\"tab\" data-toggle=\"tab\">" + (String)((Map.Entry)randAccess.get(i)).getKey() + "</a></li>\n";
        }
        tabsOpen = tabsOpen + "</ul>\n</div>\n<div class=\"panel-body tab-content no-padding\">";
        String tabsClose = "</div></div>";
        String containerContents = tabsOpen + container.getContent().toString() + tabsClose;
        return this.createBlock(parent, "pass", containerContents, inherited, new HashMap());
    }
}

