package org.mule.modules.google.api.client;

import java.util.Map;
import java.util.WeakHashMap;

import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.services.GoogleClient;

/**
 * 
 * @author mariano.gonzalez@mulesoft.com
 *
 * @param <T>
 */
public abstract class AbstractGoogleClientFactory<T extends GoogleClient> implements GoogleClientFactory<T> {

	private Map<String, T> clients = new WeakHashMap<String, T>();
	 
	public final T getClient(String accessToken, String applicationName) {
		T client = this.clients.get(accessToken);
		
    	if (client == null) {
			Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod());
			credential.setAccessToken(accessToken);
			client = this.newClient(credential, accessToken, applicationName);
					
			this.clients.put(accessToken, client);
		}
		
		return client;
	}
	
	protected abstract T newClient(Credential credential, String accessToken, String applicationName);
	
}
