/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.google.api.client;

import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.services.GoogleClient;
import java.util.Map;
import java.util.WeakHashMap;
import org.mule.modules.google.api.client.GoogleClientFactory;

public abstract class AbstractGoogleClientFactory<T extends GoogleClient>
implements GoogleClientFactory<T> {
    private Map<String, T> clients = new WeakHashMap<String, T>();

    @Override
    public final T getClient(String accessToken, String applicationName) {
        Object client = (GoogleClient)this.clients.get(accessToken);
        if (client == null) {
            Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod());
            credential.setAccessToken(accessToken);
            client = this.newClient(credential, accessToken, applicationName);
            this.clients.put(accessToken, client);
        }
        return (T)client;
    }

    protected abstract T newClient(Credential var1, String var2, String var3);
}

