/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.google.api.model;

import com.google.api.client.json.GenericJson;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class BaseWrapper<T> {
    protected T wrapped;

    public static <T extends BaseWrapper<?>, G extends GenericJson> List<T> valueOf(Collection<G> googles, Class<T> returnClass) {
        if (googles == null || googles.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<T> result = new ArrayList<T>(googles.size());
        try {
            Constructor<T> constructor = returnClass.getConstructor(((GenericJson)googles.iterator().next()).getClass());
            for (GenericJson google : googles) {
                result.add(constructor.newInstance(google));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not transform collection", e);
        }
        return result;
    }

    public static <G extends GenericJson, T extends BaseWrapper<?>> List<G> unwrapp(Collection<T> models, Class<G> returnClass) {
        if (models == null || models.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<GenericJson> result = new ArrayList<GenericJson>(models.size());
        for (BaseWrapper model : models) {
            result.add((GenericJson)model.getWrapped());
        }
        return result;
    }

    public BaseWrapper(T wrapped) {
        this.wrapped = wrapped;
    }

    public T getWrapped() {
        return this.wrapped;
    }

    public void setWrapped(T wrapped) {
        this.wrapped = wrapped;
    }
}

