package org.mule.modules.google.api.datetime;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;

import com.google.api.client.util.DateTime;

/**
 * Utility class for handling date times
 * @author mariano.gonzalez@mulesoft.com
 *
 */
public abstract class DateTimeUtils {
	
	public static DateTime parseDateTime(String date, String pattern, String timezone) {
    	if (date != null) {
    		TimeZone tz = TimeZone.getTimeZone(timezone);
    		SimpleDateFormat format = new SimpleDateFormat(pattern);
    		try {
    			return new DateTime(format.parse(date), tz);
    		} catch (ParseException e) {
    			throw new IllegalArgumentException(String.format("Can't parse date %s", date), e);
    		}
    	}
    	return null;
    }


}
