package org.mule.modules.google.api.pagination;

import org.apache.commons.lang.StringUtils;
import org.mule.api.MuleMessage;
import org.mule.api.transport.PropertyScope;

/**
 * 
 * @author mariano.gonzalez@mulesoft.com
 *
 */
public class PaginationUtils {

	/**
	 * Sets the pageToken as an outboundp property on the message under the given property name.
	 * If pageToken is blank or null, then the property is removed.
	 * 
	 * @param propertyName the name of the property on which the page token is going to be stored
	 * @param pageToken the page token
	 * @param message the current mule message
	 */
	public static void savePageToken(String propertyName, String pageToken, MuleMessage message) {
		if (StringUtils.isBlank(pageToken)) {
			message.removeProperty(propertyName, PropertyScope.INVOCATION);
    	} else {
    		message.setInvocationProperty(propertyName, pageToken);
    	}
	}
	
}
