package org.mule.modules.google.oauth.invalidation;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpStatusCodes;

/**
 * 
 * @author mariano.gonzalez@mulesoft.com
 *
 */
public class InvalidationAwareCredential extends Credential {

	public InvalidationAwareCredential(AccessMethod method) {
		super(method);
	}
	
	@Override
	public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) {
		if (response.getStatusCode() == HttpStatusCodes.STATUS_CODE_UNAUTHORIZED) {
			throw new OAuthTokenExpiredException(String.format("Service returned %d", HttpStatusCodes.STATUS_CODE_UNAUTHORIZED));
		}
		
		return false;
	}
}
