/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.geo.impl;

import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.geo.Box;
import com.google.gdata.data.geo.Namespaces;
import com.google.gdata.data.geo.Point;
import com.google.gdata.data.geo.impl.GmlEnvelope;
import com.google.gdata.data.geo.impl.GmlLowerCorner;
import com.google.gdata.data.geo.impl.GmlPoint;
import com.google.gdata.data.geo.impl.GmlUpperCorner;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;

public class GeoRssWhere
extends ExtensionPoint
implements Point,
Box {
    static final String NAME = "where";

    public GeoRssWhere() {
    }

    public GeoRssWhere(Double lat, Double lon) {
        this(new GmlPoint(lat, lon));
    }

    public GeoRssWhere(Point point) {
        if (point != null) {
            if (!(point instanceof GmlPoint)) {
                point = new GmlPoint(point);
            }
            this.setExtension(point);
        }
    }

    public GeoRssWhere(Double lowerLat, Double lowerLon, Double upperLat, Double upperLon) {
        this(new GmlEnvelope(lowerLat, lowerLon, upperLat, upperLon));
    }

    public GeoRssWhere(Point lower, Point upper) {
        this(new GmlEnvelope(lower, upper));
    }

    public GeoRssWhere(Box box) {
        if (box != null) {
            if (!(box instanceof GmlEnvelope)) {
                box = new GmlEnvelope(box);
            }
            this.setExtension(box);
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean repeatable) {
        ExtensionDescription desc = new ExtensionDescription();
        desc.setExtensionClass(GeoRssWhere.class);
        desc.setNamespace(Namespaces.GEO_RSS_NAMESPACE);
        desc.setLocalName(NAME);
        desc.setRepeatable(repeatable);
        return desc;
    }

    public static ExtensionDescription getDefaultDescription() {
        return GeoRssWhere.getDefaultDescription(true);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        extProfile.declare(GeoRssWhere.class, GmlPoint.getDefaultDescription(false));
        new GmlPoint().declareExtensions(extProfile);
        extProfile.declare(GeoRssWhere.class, GmlEnvelope.getDefaultDescription(false));
        new GmlEnvelope().declareExtensions(extProfile);
        super.declareExtensions(extProfile);
    }

    @Override
    public Double getLatitude() {
        GmlPoint point = this.getExtension(GmlPoint.class);
        return point != null ? point.getLatitude() : null;
    }

    @Override
    public Double getLongitude() {
        GmlPoint point = this.getExtension(GmlPoint.class);
        return point != null ? point.getLongitude() : null;
    }

    @Override
    public void setGeoLocation(Double lat, Double lon) {
        GmlPoint point = this.getExtension(GmlPoint.class);
        if (point != null) {
            point.setGeoLocation(lat, lon);
        } else if (lat != null || lon != null) {
            point = new GmlPoint();
            this.setExtension(point);
            point.setGeoLocation(lat, lon);
        }
    }

    @Override
    public GmlLowerCorner getLowerLeft() {
        GmlEnvelope envelope = this.getExtension(GmlEnvelope.class);
        return envelope != null ? envelope.getLowerLeft() : null;
    }

    @Override
    public GmlUpperCorner getUpperRight() {
        GmlEnvelope envelope = this.getExtension(GmlEnvelope.class);
        return envelope != null ? envelope.getUpperRight() : null;
    }

    @Override
    public void setGeoLocation(Point lowerLeft, Point upperRight) {
        GmlEnvelope envelope = this.getExtension(GmlEnvelope.class);
        if (envelope != null) {
            envelope.setGeoLocation(lowerLeft, upperRight);
        } else if (lowerLeft != null || upperRight != null) {
            envelope = new GmlEnvelope();
            this.setExtension(envelope);
            envelope.setGeoLocation(lowerLeft, upperRight);
        }
    }

    public boolean hasPoint() {
        return this.getExtension(GmlPoint.class) != null;
    }

    public boolean hasBox() {
        return this.getExtension(GmlEnvelope.class) != null;
    }

    public void clearPoint() {
        this.removeExtension(GmlPoint.class);
    }

    public void clearBox() {
        this.removeExtension(GmlEnvelope.class);
    }

    @Override
    public void generate(XmlWriter w, ExtensionProfile p) throws IOException {
        this.generateStartElement(w, Namespaces.GEO_RSS_NAMESPACE, NAME, null, null);
        this.generateExtensions(w, p);
        w.endElement(Namespaces.GEO_RSS_NAMESPACE, NAME);
    }
}

