/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.model.AttributeKey;
import com.google.gdata.model.AttributeMetadata;
import com.google.gdata.model.Element;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.ElementValidator;
import com.google.gdata.model.ValidationContext;

public class MetadataValidator
implements ElementValidator {
    @Override
    public void validate(ValidationContext vc, Element e, ElementMetadata<?, ?> metadata) {
        ElementKey<?, ?> key = metadata.getKey();
        if (e.hasTextValue()) {
            if (key.getDatatype() == Void.class) {
                vc.addError(e, CoreErrorDomain.ERR.invalidTextContent.withInternalReason("Element " + key.getId() + " must not contain text content."));
            }
        } else if (key.getDatatype() != Void.class && metadata.isContentRequired()) {
            vc.addError(e, CoreErrorDomain.ERR.missingTextContent.withInternalReason("Element " + key.getId() + " must contain a text content value."));
        }
        for (AttributeKey<?> attributeKey : metadata.getAttributes()) {
            AttributeMetadata<?> attMeta = metadata.bindAttribute(attributeKey);
            if (!attMeta.isRequired() || e.getAttributeValue(attributeKey) != null) continue;
            vc.addError(e, CoreErrorDomain.ERR.missingAttribute.withInternalReason("Element must contain value for attribute " + attributeKey.getId()));
        }
        for (ElementKey elementKey : metadata.getElements()) {
            ElementMetadata childMeta = metadata.bindElement(elementKey);
            if (!childMeta.isRequired() || e.hasElement(elementKey)) continue;
            vc.addError(e, CoreErrorDomain.ERR.missingExtensionElement.withInternalReason("Element must contain a child named " + elementKey.getId()));
        }
    }
}

