/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.google;

import com.sun.jersey.api.client.Client;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.mule.modules.google.AbstractGoogleOAuthConnector;

public abstract class GoogleUserIdExtractor {
    private static Logger logger = Logger.getLogger(GoogleUserIdExtractor.class);
    private static Client restClient = Client.create();
    private static final Pattern userIdPattern = Pattern.compile("\"user_id\"[ ]*:[ ]*\"([^\\\"]*)\"");

    public static String getUserId(AbstractGoogleOAuthConnector connector) {
        if (StringUtils.isBlank((String)connector.getUserId())) {
            String accessToken = connector.getAccessToken();
            if (StringUtils.isBlank((String)accessToken)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"NO access token yet available, returning null as user id");
                }
                return null;
            }
            String response = (String)restClient.resource("https://www.googleapis.com/oauth2/v1/tokeninfo").queryParam("alt", "json").queryParam("access_token", accessToken).get(String.class);
            Matcher matcher = userIdPattern.matcher(response);
            if (matcher.find()) {
                connector.setUserId(matcher.group(1));
            } else {
                throw new RuntimeException("Could not extract user_id from " + response);
            }
        }
        return connector.getUserId();
    }
}

