/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.google.api.util;

import com.google.gdata.data.DateTime;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public abstract class DateTimeUtils {
    public static final String RFC3339 = "yyyy-MM-dd'T'HH:mm:ssZ";

    public static DateTime parseDateTime(String date, String pattern, String timezone) {
        if (date != null) {
            TimeZone tz = null;
            if (timezone != null) {
                tz = TimeZone.getTimeZone(timezone);
            }
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            try {
                Date javaDate = format.parse(date);
                return tz != null ? new DateTime(javaDate, tz) : new DateTime(javaDate);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(String.format("Can't parse date %s", date), e);
            }
        }
        return null;
    }
}

