/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.google.api.datetime;

import com.google.api.client.util.DateTime;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public abstract class DateTimeUtils {
    public static final String RFC3339 = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    public static DateTime parseDateTime(String date, String pattern, String timezone) {
        if (date != null) {
            TimeZone tz = TimeZone.getTimeZone(timezone);
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            try {
                return new DateTime(format.parse(date), tz);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(String.format("Can't parse date %s", date), e);
            }
        }
        return null;
    }

    public static Date parseDate(String date, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        try {
            return df.parse(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(String.format("Could not parse date %s with format %s", date, format));
        }
    }
}

