/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.media.mediarss;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.HtmlTextConstruct;
import com.google.gdata.data.PlainTextConstruct;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import org.xml.sax.Attributes;

public abstract class AbstractTextElement
extends AbstractExtension {
    private TextConstruct content;

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public TextConstruct getContent() {
        return this.content;
    }

    public void setHtmlContent(String html) {
        this.content = new HtmlTextConstruct(html);
    }

    public void setPlainTextContent(String text) {
        this.content = new PlainTextConstruct(text);
    }

    public String getPlainTextContent() {
        if (this.content == null) {
            return null;
        }
        return this.content.getPlainText();
    }

    @Override
    public void putAttributes(AttributeGenerator generator) {
        if (this.content != null) {
            String type = this.content.getType() == 1 ? "plain" : "html";
            generator.put("type", type);
            if (this.content != null) {
                if (this.content instanceof HtmlTextConstruct) {
                    HtmlTextConstruct html = (HtmlTextConstruct)this.content;
                    generator.setContent(html.getHtml());
                } else {
                    generator.setContent(this.content.getPlainText());
                }
            }
        }
    }

    @Override
    protected void consumeAttributes(AttributeHelper attrsHelper) throws ParseException {
    }

    @Override
    public final XmlParser.ElementHandler getHandler(ExtensionProfile extProfile, String namespace, String localName, Attributes attrs) throws ParseException {
        final AttributeHelper attrsHelper = new AttributeHelper(attrs);
        String type = attrsHelper.consume("type", false);
        this.consumeAttributes(attrsHelper);
        if (type == null || type.equals("plain")) {
            PlainTextConstruct ptc = new PlainTextConstruct();
            this.content = ptc;
            PlainTextConstruct plainTextConstruct = ptc;
            plainTextConstruct.getClass();
            return new PlainTextConstruct.AtomHandler(plainTextConstruct){

                @Override
                public void processEndElement() throws ParseException {
                    super.processEndElement();
                    attrsHelper.assertAllConsumed();
                }
            };
        }
        if (type.equals("html")) {
            HtmlTextConstruct htc = new HtmlTextConstruct();
            this.content = htc;
            HtmlTextConstruct htmlTextConstruct = htc;
            htmlTextConstruct.getClass();
            return new HtmlTextConstruct.AtomHandler(htmlTextConstruct){

                @Override
                public void processEndElement() throws ParseException {
                    super.processEndElement();
                    attrsHelper.assertAllConsumed();
                }
            };
        }
        throw new ParseException(CoreErrorDomain.ERR.unsupportedTextType);
    }
}

