/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.sidewiki;

import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="sidewiki", nsUri="http://schemas.google.com/sidewiki/2009", localName="numEntries")
public class EntriesNumber
extends AbstractExtension {
    static final String XML_NAME = "numEntries";
    private Integer value = null;

    public EntriesNumber() {
    }

    public EntriesNumber(Integer value) {
        this.setValue(value);
        this.setImmutable(true);
    }

    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value) {
        this.throwExceptionIfImmutable();
        this.value = value;
    }

    public boolean hasValue() {
        return this.getValue() != null;
    }

    @Override
    protected void validate() {
        if (this.value != null && this.value < 0) {
            throw new IllegalStateException("Text content must be non-negative: " + this.value);
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(EntriesNumber.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    @Override
    protected void putAttributes(AttributeGenerator generator) {
        generator.setContent(this.value.toString());
    }

    @Override
    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.value = helper.consumeInteger(null, false);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        EntriesNumber other = (EntriesNumber)obj;
        return EntriesNumber.eq(this.value, other.value);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.value != null) {
            result = 37 * result + this.value.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{EntriesNumber value=" + this.value + "}";
    }
}

